/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.pravega.schemaregistry.contract.data.Compatibility;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import lombok.NonNull;

public class GroupProperties {
    @NonNull
    private final SerializationFormat serializationFormat;
    @NonNull
    private final Compatibility compatibility;
    private final boolean allowMultipleTypes;
    @NonNull
    private final ImmutableMap<String, String> properties;

    public GroupProperties(SerializationFormat serializationFormat, Compatibility compatibility, boolean allowMultipleTypes) {
        this(serializationFormat, compatibility, allowMultipleTypes, ImmutableMap.of());
    }

    public GroupProperties(@NonNull SerializationFormat serializationFormat, @NonNull Compatibility compatibility, boolean allowMultipleTypes, @NonNull ImmutableMap<String, String> properties) {
        if (serializationFormat == null) {
            throw new NullPointerException("serializationFormat is marked @NonNull but is null");
        }
        if (compatibility == null) {
            throw new NullPointerException("compatibility is marked @NonNull but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        Preconditions.checkArgument(properties != null && properties.size() <= 100 && properties.entrySet().stream().allMatch(x -> ((String)x.getKey()).length() <= 200 && ((String)x.getValue()).length() <= 200), "Invalid properties, make sure each key and value are less than or equal to 200 bytes and there are no more than 100 entries.");
        this.serializationFormat = serializationFormat;
        this.compatibility = compatibility;
        this.allowMultipleTypes = allowMultipleTypes;
        this.properties = properties;
    }

    public static GroupPropertiesBuilder builder() {
        return new GroupPropertiesBuilder();
    }

    @NonNull
    public SerializationFormat getSerializationFormat() {
        return this.serializationFormat;
    }

    @NonNull
    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public boolean isAllowMultipleTypes() {
        return this.allowMultipleTypes;
    }

    @NonNull
    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupProperties)) {
            return false;
        }
        GroupProperties other = (GroupProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SerializationFormat this$serializationFormat = this.getSerializationFormat();
        SerializationFormat other$serializationFormat = other.getSerializationFormat();
        if (this$serializationFormat == null ? other$serializationFormat != null : !((Object)((Object)this$serializationFormat)).equals((Object)other$serializationFormat)) {
            return false;
        }
        Compatibility this$compatibility = this.getCompatibility();
        Compatibility other$compatibility = other.getCompatibility();
        if (this$compatibility == null ? other$compatibility != null : !((Object)this$compatibility).equals(other$compatibility)) {
            return false;
        }
        if (this.isAllowMultipleTypes() != other.isAllowMultipleTypes()) {
            return false;
        }
        ImmutableMap<String, String> this$properties = this.getProperties();
        ImmutableMap<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SerializationFormat $serializationFormat = this.getSerializationFormat();
        result = result * 59 + ($serializationFormat == null ? 43 : ((Object)((Object)$serializationFormat)).hashCode());
        Compatibility $compatibility = this.getCompatibility();
        result = result * 59 + ($compatibility == null ? 43 : ((Object)$compatibility).hashCode());
        result = result * 59 + (this.isAllowMultipleTypes() ? 79 : 97);
        ImmutableMap<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "GroupProperties(serializationFormat=" + (Object)((Object)this.getSerializationFormat()) + ", compatibility=" + this.getCompatibility() + ", allowMultipleTypes=" + this.isAllowMultipleTypes() + ", properties=" + this.getProperties() + ")";
    }

    public static final class GroupPropertiesBuilder {
        private SerializationFormat serializationFormat;
        private Compatibility compatibility = Compatibility.fullTransitive();
        private boolean allowMultipleTypes = false;
        private ImmutableMap<String, String> properties = ImmutableMap.of();

        public GroupPropertiesBuilder compatibility(Compatibility rule) {
            this.compatibility = rule;
            return this;
        }

        GroupPropertiesBuilder() {
        }

        public GroupPropertiesBuilder serializationFormat(@NonNull SerializationFormat serializationFormat) {
            if (serializationFormat == null) {
                throw new NullPointerException("serializationFormat is marked @NonNull but is null");
            }
            this.serializationFormat = serializationFormat;
            return this;
        }

        public GroupPropertiesBuilder allowMultipleTypes(boolean allowMultipleTypes) {
            this.allowMultipleTypes = allowMultipleTypes;
            return this;
        }

        public GroupPropertiesBuilder properties(@NonNull ImmutableMap<String, String> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked @NonNull but is null");
            }
            this.properties = properties;
            return this;
        }

        public GroupProperties build() {
            return new GroupProperties(this.serializationFormat, this.compatibility, this.allowMultipleTypes, this.properties);
        }

        public String toString() {
            return "GroupProperties.GroupPropertiesBuilder(serializationFormat=" + (Object)((Object)this.serializationFormat) + ", compatibility=" + this.compatibility + ", allowMultipleTypes=" + this.allowMultipleTypes + ", properties=" + this.properties + ")";
        }
    }
}

