/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public enum SerializationFormat {
    Avro,
    Protobuf,
    Json,
    Any,
    Custom;

    private String fullTypeName;

    public static SerializationFormat custom(String fullTypeName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fullTypeName));
        SerializationFormat type = Custom;
        type.setFullTypeName(fullTypeName);
        return type;
    }

    public static SerializationFormat withName(SerializationFormat format, String fullTypeName) {
        Preconditions.checkArgument(format != null);
        SerializationFormat type = SerializationFormat.valueOf(format.name());
        type.setFullTypeName(fullTypeName);
        return type;
    }

    public String getFullTypeName() {
        return this.fullTypeName;
    }

    private void setFullTypeName(String fullTypeName) {
        this.fullTypeName = fullTypeName;
    }
}

