/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.data;

import io.pravega.common.ObjectBuilder;
import lombok.NonNull;

public class VersionInfo {
    @NonNull
    private final String type;
    private final int version;
    private final int id;

    public static VersionInfoBuilder builder() {
        return new VersionInfoBuilder();
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getId();
        return result;
    }

    public String toString() {
        return "VersionInfo(type=" + this.getType() + ", version=" + this.getVersion() + ", id=" + this.getId() + ")";
    }

    public VersionInfo(@NonNull String type, int version, int id) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.type = type;
        this.version = version;
        this.id = id;
    }

    public static class VersionInfoBuilder
    implements ObjectBuilder<VersionInfo> {
        private String type;
        private int version;
        private int id;

        VersionInfoBuilder() {
        }

        public VersionInfoBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.type = type;
            return this;
        }

        public VersionInfoBuilder version(int version) {
            this.version = version;
            return this;
        }

        public VersionInfoBuilder id(int id) {
            this.id = id;
            return this;
        }

        @Override
        public VersionInfo build() {
            return new VersionInfo(this.type, this.version, this.id);
        }

        public String toString() {
            return "VersionInfo.VersionInfoBuilder(type=" + this.type + ", version=" + this.version + ", id=" + this.id + ")";
        }
    }
}

