/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.contract.generated.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.schemaregistry.contract.generated.rest.model.Compatibility;
import io.pravega.schemaregistry.contract.generated.rest.model.SchemaInfo;
import io.pravega.schemaregistry.contract.generated.rest.model.VersionInfo;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModel;
import io.pravega.schemaregistry.shaded.io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@ApiModel(description="Group History Record that describes each schema evolution - schema information, version generated for the schema, time and compatibility policy used for schema validation.")
public class GroupHistoryRecord {
    @JsonProperty(value="schemaInfo")
    private SchemaInfo schemaInfo = null;
    @JsonProperty(value="versionInfo")
    private VersionInfo versionInfo = null;
    @JsonProperty(value="compatibility")
    private Compatibility compatibility = null;
    @JsonProperty(value="timestamp")
    private Long timestamp = null;
    @JsonProperty(value="schemaString")
    private String schemaString = null;

    public GroupHistoryRecord schemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
        return this;
    }

    @JsonProperty(value="schemaInfo")
    @ApiModelProperty(required=true, value="Schema information object.")
    @NotNull
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public GroupHistoryRecord versionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    @JsonProperty(value="versionInfo")
    @ApiModelProperty(required=true, value="Schema version information object.")
    @NotNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public GroupHistoryRecord compatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
        return this;
    }

    @JsonProperty(value="compatibility")
    @ApiModelProperty(required=true, value="Schema compatibility applied.")
    @NotNull
    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public GroupHistoryRecord timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="timestamp")
    @ApiModelProperty(required=true, value="Timestamp when the schema was added.")
    @NotNull
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public GroupHistoryRecord schemaString(String schemaString) {
        this.schemaString = schemaString;
        return this;
    }

    @JsonProperty(value="schemaString")
    @ApiModelProperty(value="Schema as json string for serialization formats that registry service understands.")
    public String getSchemaString() {
        return this.schemaString;
    }

    public void setSchemaString(String schemaString) {
        this.schemaString = schemaString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupHistoryRecord groupHistoryRecord = (GroupHistoryRecord)o;
        return Objects.equals(this.schemaInfo, groupHistoryRecord.schemaInfo) && Objects.equals(this.versionInfo, groupHistoryRecord.versionInfo) && Objects.equals(this.compatibility, groupHistoryRecord.compatibility) && Objects.equals(this.timestamp, groupHistoryRecord.timestamp) && Objects.equals(this.schemaString, groupHistoryRecord.schemaString);
    }

    public int hashCode() {
        return Objects.hash(this.schemaInfo, this.versionInfo, this.compatibility, this.timestamp, this.schemaString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupHistoryRecord {\n");
        sb.append("    schemaInfo: ").append(this.toIndentedString(this.schemaInfo)).append("\n");
        sb.append("    versionInfo: ").append(this.toIndentedString(this.versionInfo)).append("\n");
        sb.append("    compatibility: ").append(this.toIndentedString(this.compatibility)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    schemaString: ").append(this.toIndentedString(this.schemaString)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

