/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.avro.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;

class AvroDeserializer<T>
extends AbstractDeserializer<T> {
    private final AvroSchema<T> avroSchema;
    private final ConcurrentHashMap<SchemaInfo, Schema> knownSchemas;

    AvroDeserializer(String groupId, SchemaRegistryClient client, AvroSchema<T> schema, SerializerConfig.Decoders decoder, EncodingCache encodingCache) {
        super(groupId, client, schema, false, decoder, encodingCache, true);
        Preconditions.checkNotNull(schema);
        this.avroSchema = schema;
        this.knownSchemas = new ConcurrentHashMap();
    }

    @Override
    public final T deserialize(InputStream inputStream, SchemaInfo writerSchemaInfo, SchemaInfo readerSchemaInfo) throws IOException {
        Schema writerSchema;
        Preconditions.checkNotNull(writerSchemaInfo);
        if (this.knownSchemas.containsKey(writerSchemaInfo)) {
            writerSchema = this.knownSchemas.get(writerSchemaInfo);
        } else {
            String schemaString = new String(writerSchemaInfo.getSchemaData().array(), Charsets.UTF_8);
            writerSchema = new Schema.Parser().parse(schemaString);
            this.knownSchemas.put(writerSchemaInfo, writerSchema);
        }
        Schema readerSchema = this.avroSchema.getSchema();
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inputStream, null);
        if (SpecificRecordBase.class.isAssignableFrom(this.avroSchema.getTClass())) {
            SpecificDatumReader datumReader = new SpecificDatumReader(writerSchema, readerSchema);
            return datumReader.read(null, decoder);
        }
        ReflectDatumReader datumReader = new ReflectDatumReader(writerSchema, readerSchema);
        return datumReader.read(null, decoder);
    }
}

