/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.json.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.io.IOException;
import java.io.InputStream;

public class JsonDeserializer<T>
extends AbstractDeserializer<T> {
    private final JSONSchema<T> jsonSchema;
    private final ObjectMapper objectMapper;

    public JsonDeserializer(String groupId, SchemaRegistryClient client, JSONSchema<T> schema, SerializerConfig.Decoders decoders, EncodingCache encodingCache, boolean encodeHeader) {
        super(groupId, client, schema, true, decoders, encodingCache, encodeHeader);
        Preconditions.checkNotNull(schema);
        this.jsonSchema = schema;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    public final T deserialize(InputStream inputStream, SchemaInfo writerSchemaInfo, SchemaInfo readerSchemaInfo) throws IOException {
        return this.objectMapper.readValue(inputStream, this.jsonSchema.getDerived());
    }
}

