/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.protobuf.impl;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.protobuf.schemas.ProtobufSchema;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.io.IOException;
import java.io.InputStream;

public class ProtobufDeserializer<T extends GeneratedMessageV3>
extends AbstractDeserializer<T> {
    private final ProtobufSchema<T> protobufSchema;

    ProtobufDeserializer(String groupId, SchemaRegistryClient client, ProtobufSchema<T> schema, SerializerConfig.Decoders decoder, EncodingCache encodingCache, boolean encodeHeader) {
        super(groupId, client, schema, true, decoder, encodingCache, encodeHeader);
        Preconditions.checkNotNull(schema);
        this.protobufSchema = schema;
    }

    @Override
    public final T deserialize(InputStream inputStream, SchemaInfo writerSchemaInfo, SchemaInfo readerSchemaInfo) throws IOException {
        try {
            return (T)((GeneratedMessageV3)this.protobufSchema.getParser().parseFrom(inputStream));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException("Invalid protobuffer serialized bytes", e);
        }
    }
}

