/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.protobuf.schemas;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;

public class ProtobufSchema<T extends Message>
implements Schema<T> {
    private final Parser<T> parser;
    private final Class<T> tClass;
    private final DescriptorProtos.FileDescriptorSet fileDescriptorSet;
    private final SchemaInfo schemaInfo;

    private ProtobufSchema(String name, Parser<T> parser, Class<T> tClass, DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        this.parser = parser;
        this.tClass = tClass;
        this.fileDescriptorSet = fileDescriptorSet;
        this.schemaInfo = new SchemaInfo(name, SerializationFormat.Protobuf, this.getSchemaBytes(), ImmutableMap.of());
    }

    private ProtobufSchema(DescriptorProtos.FileDescriptorSet fileDescriptorSet, SchemaInfo schemaInfo, Class<T> tClass) {
        this.parser = null;
        this.tClass = null;
        this.fileDescriptorSet = fileDescriptorSet;
        this.schemaInfo = schemaInfo;
    }

    private ByteBuffer getSchemaBytes() {
        return ByteBuffer.wrap(this.fileDescriptorSet.toByteArray());
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<T> of(Class<T> tClass) {
        Extractor<T> extractor = new Extractor<T>(tClass).invoke();
        return new ProtobufSchema<T>(extractor.getFullName(), ((Extractor)extractor).getParser(), tClass, extractor.getFileDescriptorSet());
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<T> of(Class<T> tClass, DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        Extractor<T> extractor = new Extractor<T>(tClass).invoke();
        return new ProtobufSchema<T>(extractor.getFullName(), ((Extractor)extractor).getParser(), tClass, fileDescriptorSet);
    }

    public static ProtobufSchema<DynamicMessage> of(String name, DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        return new ProtobufSchema<DynamicMessage>(name, null, DynamicMessage.class, fileDescriptorSet);
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<GeneratedMessageV3> ofGeneratedMessageV3(Class<T> tClass, DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        Extractor<T> extractor = new Extractor<T>(tClass).invoke();
        return new ProtobufSchema<GeneratedMessageV3>(extractor.getFullName(), ((Extractor)extractor).getParser(), GeneratedMessageV3.class, fileDescriptorSet);
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<GeneratedMessageV3> ofGeneratedMessageV3(Class<T> tClass) {
        Extractor<T> extractor = new Extractor<T>(tClass).invoke();
        return new ProtobufSchema<GeneratedMessageV3>(extractor.getFullName(), ((Extractor)extractor).getParser(), GeneratedMessageV3.class, extractor.getFileDescriptorSet());
    }

    public static ProtobufSchema<DynamicMessage> from(SchemaInfo schemaInfo) {
        try {
            DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom(schemaInfo.getSchemaData());
            return new ProtobufSchema<DynamicMessage>(fileDescriptorSet, schemaInfo, DynamicMessage.class);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new IllegalArgumentException("Unable to get protobuf schema from schemainfo", ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtobufSchema)) {
            return false;
        }
        ProtobufSchema other = (ProtobufSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Parser<T> this$parser = this.getParser();
        Parser<T> other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        Class<T> this$tClass = this.getTClass();
        Class<T> other$tClass = other.getTClass();
        if (this$tClass == null ? other$tClass != null : !this$tClass.equals(other$tClass)) {
            return false;
        }
        DescriptorProtos.FileDescriptorSet this$fileDescriptorSet = this.getFileDescriptorSet();
        DescriptorProtos.FileDescriptorSet other$fileDescriptorSet = other.getFileDescriptorSet();
        if (this$fileDescriptorSet == null ? other$fileDescriptorSet != null : !((Object)this$fileDescriptorSet).equals(other$fileDescriptorSet)) {
            return false;
        }
        SchemaInfo this$schemaInfo = this.getSchemaInfo();
        SchemaInfo other$schemaInfo = other.getSchemaInfo();
        return !(this$schemaInfo == null ? other$schemaInfo != null : !((Object)this$schemaInfo).equals(other$schemaInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtobufSchema;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Parser<T> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        Class<T> $tClass = this.getTClass();
        result = result * 59 + ($tClass == null ? 43 : $tClass.hashCode());
        DescriptorProtos.FileDescriptorSet $fileDescriptorSet = this.getFileDescriptorSet();
        result = result * 59 + ($fileDescriptorSet == null ? 43 : ((Object)$fileDescriptorSet).hashCode());
        SchemaInfo $schemaInfo = this.getSchemaInfo();
        result = result * 59 + ($schemaInfo == null ? 43 : ((Object)$schemaInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ProtobufSchema(parser=" + this.getParser() + ", tClass=" + this.getTClass() + ", fileDescriptorSet=" + this.getFileDescriptorSet() + ", schemaInfo=" + this.getSchemaInfo() + ")";
    }

    public Parser<T> getParser() {
        return this.parser;
    }

    @Override
    public Class<T> getTClass() {
        return this.tClass;
    }

    public DescriptorProtos.FileDescriptorSet getFileDescriptorSet() {
        return this.fileDescriptorSet;
    }

    private static class Extractor<T extends GeneratedMessageV3> {
        private Class<T> tClass;
        private T defaultInstance;
        private Parser<T> parser;

        Extractor(Class<T> tClass) {
            this.tClass = tClass;
        }

        String getFullName() {
            return ((GeneratedMessageV3)this.defaultInstance).getDescriptorForType().getFullName();
        }

        DescriptorProtos.FileDescriptorSet getFileDescriptorSet() {
            return DescriptorProtos.FileDescriptorSet.newBuilder().addFile(((GeneratedMessageV3)this.defaultInstance).getDescriptorForType().getFile().toProto()).build();
        }

        Extractor<T> invoke() {
            try {
                this.defaultInstance = (GeneratedMessageV3)this.tClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            this.parser = ((GeneratedMessageV3)this.defaultInstance).getParserForType();
            return this;
        }

        private Class<T> getTClass() {
            return this.tClass;
        }

        private T getDefaultInstance() {
            return this.defaultInstance;
        }

        private Parser<T> getParser() {
            return this.parser;
        }
    }
}

