/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.base.Preconditions;
import io.pravega.common.io.EnhancedByteArrayOutputStream;
import io.pravega.common.util.BitConverter;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.EncodingId;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.VersionInfo;
import io.pravega.schemaregistry.serializer.shared.codec.Codecs;
import io.pravega.schemaregistry.serializer.shared.codec.Encoder;
import io.pravega.schemaregistry.serializer.shared.impl.BaseSerializer;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractSerializer<T>
extends BaseSerializer<T> {
    private static final byte PROTOCOL = 1;
    private final String groupId;
    private final SchemaInfo schemaInfo;
    private final AtomicReference<EncodingId> encodingId;
    private final boolean encodeHeader;
    private final SchemaRegistryClient client;
    private final Encoder encoder;
    private final boolean registerSchema;

    protected AbstractSerializer(String groupId, SchemaRegistryClient client, Schema<T> schema, Encoder encoder, boolean registerSchema, boolean encodeHeader) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(client);
        Preconditions.checkNotNull(encoder);
        Preconditions.checkNotNull(schema);
        Preconditions.checkArgument(encodeHeader || encoder.equals(Codecs.None.getCodec()), "Cannot use encoder if encoder header is false.");
        this.groupId = groupId;
        this.client = client;
        this.schemaInfo = schema.getSchemaInfo();
        this.registerSchema = registerSchema;
        this.encodingId = new AtomicReference();
        this.encoder = encoder;
        this.encodeHeader = encodeHeader;
        this.initialize();
    }

    private void initialize() {
        VersionInfo version = this.registerSchema ? this.client.addSchema(this.groupId, this.schemaInfo) : this.client.getVersionForSchema(this.groupId, this.schemaInfo);
        if (this.encodeHeader) {
            this.encodingId.set(this.client.getEncodingId(this.groupId, version, this.encoder.getCodecType().getName()));
        }
    }

    @Override
    public ByteBuffer serialize(T obj) {
        EnhancedByteArrayOutputStream outStream = new EnhancedByteArrayOutputStream();
        if (this.encodeHeader) {
            outStream.write(1);
            BitConverter.writeInt(outStream, this.encodingId.get().getId());
        }
        if (!this.encodeHeader || this.encoder.equals(Codecs.None.getCodec())) {
            this.serialize(obj, this.schemaInfo, outStream);
        } else {
            EnhancedByteArrayOutputStream serializedStream = new EnhancedByteArrayOutputStream();
            this.serialize(obj, this.schemaInfo, serializedStream);
            this.encoder.encode(ByteBuffer.wrap(serializedStream.getData().array()), outStream);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(outStream.getData().array(), 0, outStream.getData().getLength());
        return byteBuffer;
    }

    protected abstract void serialize(T var1, SchemaInfo var2, OutputStream var3) throws IOException;

    public Encoder getEncoder() {
        return this.encoder;
    }
}

