/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.CustomDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.CustomSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerFactoryHelper;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSerializerFactory {
    private static final Logger log = LoggerFactory.getLogger(CustomSerializerFactory.class);

    public static <T> Serializer<T> serializer(@NonNull SerializerConfig config, @NonNull Schema<T> schema, final @NonNull CustomSerializer<T> serializer) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked @NonNull but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked @NonNull but is null");
        }
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForSerializer(config);
        return new AbstractSerializer<T>(groupId, schemaRegistryClient, schema, config.getEncoder(), config.isRegisterSchema(), config.isWriteEncodingHeader()){

            @Override
            protected void serialize(T var, SchemaInfo schema, OutputStream outputStream) {
                serializer.serialize(var, schema, outputStream);
            }
        };
    }

    public static <T> Serializer<T> deserializer(@NonNull SerializerConfig config, @Nullable Schema<T> schema, final @NonNull CustomDeserializer<T> deserializer) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (deserializer == null) {
            throw new NullPointerException("deserializer is marked @NonNull but is null");
        }
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new AbstractDeserializer<T>(groupId, schemaRegistryClient, schema, false, config.getDecoders(), encodingCache, config.isWriteEncodingHeader()){

            @Override
            public final T deserialize(InputStream inputStream, SchemaInfo writerSchema, SchemaInfo readerSchema) {
                return deserializer.deserialize(inputStream, writerSchema, readerSchema);
            }
        };
    }
}

