/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.base.Preconditions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.SerializationException;

public class MultiplexedDeserializer<T>
extends AbstractDeserializer<T> {
    private final Map<String, AbstractDeserializer<T>> deserializers;

    public MultiplexedDeserializer(String groupId, SchemaRegistryClient client, Map<String, AbstractDeserializer<T>> deserializers, SerializerConfig.Decoders decoders, EncodingCache encodingCache) {
        super(groupId, client, null, false, decoders, encodingCache, true);
        this.deserializers = deserializers;
    }

    @Override
    public final T deserialize(InputStream inputStream, SchemaInfo writerSchema, SchemaInfo readerSchema) throws IOException {
        Preconditions.checkNotNull(writerSchema);
        AbstractDeserializer<T> deserializer = this.deserializers.get(writerSchema.getType());
        if (deserializer == null) {
            throw new SerializationException("deserializer not supplied for type " + writerSchema.getType());
        }
        return deserializer.deserialize(inputStream, writerSchema, readerSchema);
    }
}

