/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.client.SchemaRegistryClientConfig;
import io.pravega.schemaregistry.common.Either;
import io.pravega.schemaregistry.contract.data.CodecType;
import io.pravega.schemaregistry.contract.data.Compatibility;
import io.pravega.schemaregistry.contract.data.GroupProperties;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.shared.codec.Codec;
import io.pravega.schemaregistry.serializer.shared.codec.Codecs;
import io.pravega.schemaregistry.serializer.shared.codec.Decoder;
import io.pravega.schemaregistry.serializer.shared.codec.Encoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class SerializerConfig {
    @NonNull
    private final String groupId;
    private final String namespace;
    private final SchemaRegistryClientConfig registryConfig;
    private final SchemaRegistryClient registryClient;
    private final boolean registerSchema;
    private final boolean registerCodec;
    private final Encoder encoder;
    private final Decoders decoders;
    private final boolean failOnCodecMismatch;
    private final GroupProperties createGroup;
    private final boolean writeEncodingHeader;

    private SerializerConfig(String groupId, String namespace, SchemaRegistryClientConfig config, SchemaRegistryClient client, boolean registerSchema, boolean registerCodec, Encoder encoder, Decoders decoders, boolean failOnCodecMismatch, GroupProperties createGroup, boolean writeEncodingHeader) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(groupId), "Group id needs to be supplied");
        Preconditions.checkArgument(client != null || config != null, "Either registry client or config needs to be supplied");
        this.groupId = groupId;
        this.namespace = namespace;
        this.registryClient = client;
        this.registryConfig = config;
        this.registerSchema = registerSchema;
        this.registerCodec = registerCodec;
        this.encoder = encoder;
        this.decoders = decoders;
        this.failOnCodecMismatch = failOnCodecMismatch;
        this.createGroup = createGroup;
        this.writeEncodingHeader = writeEncodingHeader;
    }

    Either<SchemaRegistryClientConfig, SchemaRegistryClient> getRegistryConfigOrClient() {
        if (this.registryClient == null) {
            return Either.left(this.registryConfig);
        }
        return Either.right(this.registryClient);
    }

    public boolean isCreateGroup() {
        return this.createGroup != null;
    }

    GroupProperties getGroupProperties() {
        return this.createGroup;
    }

    public static SerializerConfigBuilder builder() {
        return new SerializerConfigBuilder();
    }

    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isRegisterSchema() {
        return this.registerSchema;
    }

    public boolean isRegisterCodec() {
        return this.registerCodec;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Decoders getDecoders() {
        return this.decoders;
    }

    public boolean isFailOnCodecMismatch() {
        return this.failOnCodecMismatch;
    }

    public boolean isWriteEncodingHeader() {
        return this.writeEncodingHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializerConfig)) {
            return false;
        }
        SerializerConfig other = (SerializerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        SchemaRegistryClientConfig this$registryConfig = this.registryConfig;
        SchemaRegistryClientConfig other$registryConfig = other.registryConfig;
        if (this$registryConfig == null ? other$registryConfig != null : !((Object)this$registryConfig).equals(other$registryConfig)) {
            return false;
        }
        SchemaRegistryClient this$registryClient = this.registryClient;
        SchemaRegistryClient other$registryClient = other.registryClient;
        if (this$registryClient == null ? other$registryClient != null : !this$registryClient.equals(other$registryClient)) {
            return false;
        }
        if (this.isRegisterSchema() != other.isRegisterSchema()) {
            return false;
        }
        if (this.isRegisterCodec() != other.isRegisterCodec()) {
            return false;
        }
        Encoder this$encoder = this.getEncoder();
        Encoder other$encoder = other.getEncoder();
        if (this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder)) {
            return false;
        }
        Decoders this$decoders = this.getDecoders();
        Decoders other$decoders = other.getDecoders();
        if (this$decoders == null ? other$decoders != null : !this$decoders.equals(other$decoders)) {
            return false;
        }
        if (this.isFailOnCodecMismatch() != other.isFailOnCodecMismatch()) {
            return false;
        }
        GroupProperties this$createGroup = this.createGroup;
        GroupProperties other$createGroup = other.createGroup;
        if (this$createGroup == null ? other$createGroup != null : !((Object)this$createGroup).equals(other$createGroup)) {
            return false;
        }
        return this.isWriteEncodingHeader() == other.isWriteEncodingHeader();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SerializerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        SchemaRegistryClientConfig $registryConfig = this.registryConfig;
        result = result * 59 + ($registryConfig == null ? 43 : ((Object)$registryConfig).hashCode());
        SchemaRegistryClient $registryClient = this.registryClient;
        result = result * 59 + ($registryClient == null ? 43 : $registryClient.hashCode());
        result = result * 59 + (this.isRegisterSchema() ? 79 : 97);
        result = result * 59 + (this.isRegisterCodec() ? 79 : 97);
        Encoder $encoder = this.getEncoder();
        result = result * 59 + ($encoder == null ? 43 : $encoder.hashCode());
        Decoders $decoders = this.getDecoders();
        result = result * 59 + ($decoders == null ? 43 : $decoders.hashCode());
        result = result * 59 + (this.isFailOnCodecMismatch() ? 79 : 97);
        GroupProperties $createGroup = this.createGroup;
        result = result * 59 + ($createGroup == null ? 43 : ((Object)$createGroup).hashCode());
        result = result * 59 + (this.isWriteEncodingHeader() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SerializerConfig(groupId=" + this.getGroupId() + ", namespace=" + this.getNamespace() + ", registryConfig=" + this.registryConfig + ", registryClient=" + this.registryClient + ", registerSchema=" + this.isRegisterSchema() + ", registerCodec=" + this.isRegisterCodec() + ", encoder=" + this.getEncoder() + ", decoders=" + this.getDecoders() + ", failOnCodecMismatch=" + this.isFailOnCodecMismatch() + ", createGroup=" + this.createGroup + ", writeEncodingHeader=" + this.isWriteEncodingHeader() + ")";
    }

    public static class Decoders {
        private final ConcurrentHashMap<String, Decoder> decoders = new ConcurrentHashMap();

        Decoders() {
            this.decoders.put(Codecs.None.getCodec().getName(), Codecs.None.getCodec());
            this.decoders.put(Codecs.GzipCompressor.getCodec().getName(), Codecs.GzipCompressor.getCodec());
            this.decoders.put(Codecs.SnappyCompressor.getCodec().getName(), Codecs.SnappyCompressor.getCodec());
        }

        private void add(String codecName, Decoder decoder) {
            Preconditions.checkNotNull(codecName);
            Preconditions.checkNotNull(decoder);
            this.decoders.put(codecName, decoder);
        }

        private void addAll(Map<String, Decoder> decoders) {
            Preconditions.checkNotNull(decoders);
            this.decoders.putAll(decoders);
        }

        ByteBuffer decode(CodecType codecType, ByteBuffer bytes) throws IOException {
            return this.decoders.get(codecType.getName()).decode(bytes, codecType.getProperties());
        }

        Set<String> getDecoderNames() {
            return this.decoders.keySet();
        }
    }

    public static final class SerializerConfigBuilder {
        private String groupId;
        private GroupProperties createGroup;
        private Codec encoder = Codecs.None.getCodec();
        private Decoders decoders = new Decoders();
        private boolean registerSchema = false;
        private boolean registerCodec = false;
        private boolean failOnCodecMismatch = true;
        private boolean writeEncodingHeader = true;
        private SchemaRegistryClientConfig registryConfig = null;
        private SchemaRegistryClient registryClient = null;
        private String namespace = null;

        public SerializerConfigBuilder decoder(String name, Decoder decoder) {
            this.decoders.add(name, decoder);
            return this;
        }

        public SerializerConfigBuilder decoders(Map<String, Decoder> decoders) {
            this.decoders.addAll(decoders);
            return this;
        }

        public SerializerConfigBuilder createGroup(SerializationFormat serializationFormat) {
            return this.createGroup(serializationFormat, true);
        }

        public SerializerConfigBuilder createGroup(SerializationFormat serializationFormat, boolean allowMultipleTypes) {
            Compatibility policy = serializationFormat.equals((Object)SerializationFormat.Any) ? Compatibility.allowAny() : Compatibility.fullTransitive();
            return this.createGroup(serializationFormat, policy, allowMultipleTypes);
        }

        public SerializerConfigBuilder createGroup(SerializationFormat serializationFormat, Compatibility policy, boolean allowMultipleTypes) {
            this.createGroup = new GroupProperties(serializationFormat, policy, allowMultipleTypes);
            return this;
        }

        public SerializerConfigBuilder registryClient(SchemaRegistryClient client) {
            Preconditions.checkArgument(client != null);
            Preconditions.checkState(this.registryConfig == null, "Cannot specify both client and config");
            this.registryClient = client;
            return this;
        }

        public SerializerConfigBuilder registryConfig(SchemaRegistryClientConfig config) {
            Preconditions.checkArgument(config != null);
            Preconditions.checkState(this.registryClient == null, "Cannot specify both client and config");
            this.registryConfig = config;
            return this;
        }

        SerializerConfigBuilder() {
        }

        public SerializerConfigBuilder groupId(@NonNull String groupId) {
            if (groupId == null) {
                throw new NullPointerException("groupId is marked @NonNull but is null");
            }
            this.groupId = groupId;
            return this;
        }

        public SerializerConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SerializerConfigBuilder registerSchema(boolean registerSchema) {
            this.registerSchema = registerSchema;
            return this;
        }

        public SerializerConfigBuilder registerCodec(boolean registerCodec) {
            this.registerCodec = registerCodec;
            return this;
        }

        public SerializerConfigBuilder encoder(Codec encoder) {
            this.encoder = encoder;
            return this;
        }

        public SerializerConfigBuilder failOnCodecMismatch(boolean failOnCodecMismatch) {
            this.failOnCodecMismatch = failOnCodecMismatch;
            return this;
        }

        public SerializerConfigBuilder writeEncodingHeader(boolean writeEncodingHeader) {
            this.writeEncodingHeader = writeEncodingHeader;
            return this;
        }

        public SerializerConfig build() {
            return new SerializerConfig(this.groupId, this.namespace, this.registryConfig, this.registryClient, this.registerSchema, this.registerCodec, this.encoder, this.decoders, this.failOnCodecMismatch, this.createGroup, this.writeEncodingHeader);
        }

        public String toString() {
            return "SerializerConfig.SerializerConfigBuilder(groupId=" + this.groupId + ", namespace=" + this.namespace + ", registryConfig=" + this.registryConfig + ", registryClient=" + this.registryClient + ", registerSchema=" + this.registerSchema + ", registerCodec=" + this.registerCodec + ", encoder=" + this.encoder + ", decoders=" + this.decoders + ", failOnCodecMismatch=" + this.failOnCodecMismatch + ", createGroup=" + this.createGroup + ", writeEncodingHeader=" + this.writeEncodingHeader + ")";
        }
    }
}

