/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializer.shared.impl;

import com.google.common.base.Strings;
import io.pravega.client.ClientConfig;
import io.pravega.client.stream.impl.Credentials;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.client.SchemaRegistryClientConfig;
import io.pravega.schemaregistry.client.SchemaRegistryClientFactory;
import io.pravega.schemaregistry.contract.data.CodecType;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerFactoryHelper {
    private static final Logger log = LoggerFactory.getLogger(SerializerFactoryHelper.class);

    public static SchemaRegistryClient initForSerializer(SerializerConfig config) {
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.getSchemaRegistryClient(config);
        SerializerFactoryHelper.createGroup(schemaRegistryClient, config);
        SerializerFactoryHelper.registerCodec(schemaRegistryClient, config);
        return schemaRegistryClient;
    }

    public static SchemaRegistryClient initForDeserializer(SerializerConfig config) {
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.getSchemaRegistryClient(config);
        SerializerFactoryHelper.createGroup(schemaRegistryClient, config);
        SerializerFactoryHelper.failOnCodecMismatch(schemaRegistryClient, config);
        return schemaRegistryClient;
    }

    private static SchemaRegistryClient getSchemaRegistryClient(SerializerConfig config) {
        if (config.getRegistryConfigOrClient().isLeft()) {
            SchemaRegistryClientConfig left = config.getRegistryConfigOrClient().getLeft();
            if (left.isAuthEnabled() && Strings.isNullOrEmpty(left.getAuthMethod())) {
                Credentials creds = ClientConfig.builder().build().getCredentials();
                left = SchemaRegistryClientConfig.builder().schemaRegistryUri(left.getSchemaRegistryUri()).authentication(creds.getAuthenticationType(), creds.getAuthenticationToken()).build();
            }
            return SchemaRegistryClientFactory.withNamespace(config.getNamespace(), left);
        }
        return config.getRegistryConfigOrClient().getRight();
    }

    private static void createGroup(SchemaRegistryClient client, SerializerConfig config) {
        if (config.isCreateGroup()) {
            client.addGroup(config.getGroupId(), config.getGroupProperties());
        }
    }

    private static void registerCodec(SchemaRegistryClient client, SerializerConfig config) {
        if (config.isRegisterCodec()) {
            client.addCodecType(config.getGroupId(), config.getEncoder().getCodecType());
        }
    }

    private static void failOnCodecMismatch(SchemaRegistryClient client, SerializerConfig config) {
        if (config.isFailOnCodecMismatch()) {
            List codecTypesInGroup = client.getCodecTypes(config.getGroupId()).stream().map(CodecType::getName).collect(Collectors.toList());
            if (!config.getDecoders().getDecoderNames().containsAll(codecTypesInGroup)) {
                log.warn("Not all CodecTypes are supported by reader. Required codecTypes = {}", (Object)codecTypesInGroup);
                throw new RuntimeException(String.format("Need all codecTypes in %s", codecTypesInGroup.toString()));
            }
        }
    }
}

