/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializers.WithSchema;
import java.io.IOException;
import java.io.InputStream;

class JsonWithSchemaDeserializer
extends AbstractDeserializer<WithSchema<JsonNode>> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    JsonWithSchemaDeserializer(String groupId, SchemaRegistryClient client, SerializerConfig.Decoders decoders, EncodingCache encodingCache, boolean encodeHeader) {
        super(groupId, client, null, false, decoders, encodingCache, encodeHeader);
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
    }

    @Override
    public final WithSchema<JsonNode> deserialize(InputStream inputStream, SchemaInfo writerSchemaInfo, SchemaInfo readerSchemaInfo) throws IOException {
        JsonNode obj = this.objectMapper.readTree(inputStream);
        return new WithSchema<JsonNode>(writerSchemaInfo, obj, (x, y) -> (JsonNode)y);
    }
}

