/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import com.google.common.base.Preconditions;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.shared.impl.AbstractDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializers.WithSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.BiFunction;

class MultiFormatWithSchemaDeserializer<T>
extends AbstractDeserializer<WithSchema<T>> {
    private final Map<SerializationFormat, AbstractDeserializer> genericDeserializers;
    private final BiFunction<SerializationFormat, Object, T> transform;

    MultiFormatWithSchemaDeserializer(String groupId, SchemaRegistryClient client, Map<SerializationFormat, AbstractDeserializer> genericDeserializers, SerializerConfig.Decoders decoders, EncodingCache encodingCache, BiFunction<SerializationFormat, Object, T> transform) {
        super(groupId, client, null, false, decoders, encodingCache, true);
        this.genericDeserializers = genericDeserializers;
        this.transform = transform;
    }

    @Override
    public final WithSchema<T> deserialize(InputStream inputStream, SchemaInfo writerSchema, SchemaInfo readerSchema) throws IOException {
        Preconditions.checkNotNull(writerSchema);
        Object obj = this.genericDeserializers.get((Object)writerSchema.getSerializationFormat()).deserialize(inputStream, writerSchema, readerSchema);
        if (obj instanceof WithSchema) {
            obj = ((WithSchema)obj).getObject();
        }
        return new WithSchema<T>(writerSchema, obj, this.transform);
    }
}

