/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import io.pravega.client.stream.Serializer;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.common.Either;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.avro.impl.AvroSerializerFactory;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.json.impl.JsonDeserializer;
import io.pravega.schemaregistry.serializer.json.impl.JsonSerializerFactory;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.protobuf.impl.ProtobufSerializerFactory;
import io.pravega.schemaregistry.serializer.protobuf.schemas.ProtobufSchema;
import io.pravega.schemaregistry.serializer.shared.impl.CustomDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.CustomSerializer;
import io.pravega.schemaregistry.serializer.shared.impl.CustomSerializerFactory;
import io.pravega.schemaregistry.serializer.shared.impl.EncodingCache;
import io.pravega.schemaregistry.serializer.shared.impl.MultiplexedAndGenericDeserializer;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerFactoryHelper;
import io.pravega.schemaregistry.serializer.shared.schemas.Schema;
import io.pravega.schemaregistry.serializers.JsonWithSchemaDeserializer;
import io.pravega.schemaregistry.serializers.MultiFormatSerializerFactory;
import io.pravega.schemaregistry.serializers.WithSchema;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerFactory {
    private static final Logger log = LoggerFactory.getLogger(SerializerFactory.class);

    public static <T> Serializer<T> avroSerializer(SerializerConfig config, AvroSchema<T> schema) {
        return AvroSerializerFactory.serializer(config, schema);
    }

    public static <T> Serializer<T> avroDeserializer(SerializerConfig config, AvroSchema<T> schema) {
        return AvroSerializerFactory.deserializer(config, schema);
    }

    public static Serializer<Object> avroGenericDeserializer(SerializerConfig config, @Nullable AvroSchema<Object> schema) {
        return AvroSerializerFactory.genericDeserializer(config, schema);
    }

    public static <T> Serializer<T> avroMultiTypeSerializer(SerializerConfig config, Map<Class<? extends T>, AvroSchema<T>> schemas) {
        return AvroSerializerFactory.multiTypeSerializer(config, schemas);
    }

    public static <T> Serializer<T> avroMultiTypeDeserializer(SerializerConfig config, Map<Class<? extends T>, AvroSchema<T>> schemas) {
        return AvroSerializerFactory.multiTypeDeserializer(config, schemas);
    }

    public static <T> Serializer<Either<T, Object>> avroTypedOrGenericDeserializer(SerializerConfig config, Map<Class<? extends T>, AvroSchema<T>> schemas) {
        return AvroSerializerFactory.typedOrGenericDeserializer(config, schemas);
    }

    public static <T extends Message> Serializer<T> protobufSerializer(SerializerConfig config, ProtobufSchema<T> schema) {
        return ProtobufSerializerFactory.serializer(config, schema);
    }

    public static <T extends GeneratedMessageV3> Serializer<T> protobufDeserializer(SerializerConfig config, ProtobufSchema<T> schema) {
        return ProtobufSerializerFactory.deserializer(config, schema);
    }

    public static Serializer<DynamicMessage> protobufGenericDeserializer(SerializerConfig config, @Nullable ProtobufSchema<DynamicMessage> schema) {
        return ProtobufSerializerFactory.genericDeserializer(config, schema);
    }

    public static <T extends GeneratedMessageV3> Serializer<T> protobufMultiTypeSerializer(SerializerConfig config, Map<Class<? extends T>, ProtobufSchema<T>> schemas) {
        return ProtobufSerializerFactory.multiTypeSerializer(config, schemas);
    }

    public static <T extends GeneratedMessageV3> Serializer<T> protobufMultiTypeDeserializer(SerializerConfig config, Map<Class<? extends T>, ProtobufSchema<T>> schemas) {
        return ProtobufSerializerFactory.multiTypeDeserializer(config, schemas);
    }

    public static <T extends GeneratedMessageV3> Serializer<Either<T, DynamicMessage>> protobufTypedOrGenericDeserializer(SerializerConfig config, Map<Class<? extends T>, ProtobufSchema<T>> schemas) {
        return ProtobufSerializerFactory.typedOrGenericDeserializer(config, schemas);
    }

    public static <T> Serializer<T> jsonSerializer(SerializerConfig config, JSONSchema<T> schema) {
        return JsonSerializerFactory.serializer(config, schema);
    }

    public static <T> Serializer<T> jsonDeserializer(@NonNull SerializerConfig config, @Nullable JSONSchema<T> schema) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return JsonSerializerFactory.deserializer(config, schema);
    }

    public static Serializer<WithSchema<JsonNode>> jsonGenericDeserializer(@NonNull SerializerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        String groupId = config.getGroupId();
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        return new JsonWithSchemaDeserializer(groupId, schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
    }

    public static Serializer<String> jsonStringDeserializer(@NonNull SerializerConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        return JsonSerializerFactory.deserializeAsString(config);
    }

    public static <T> Serializer<T> jsonMultiTypeSerializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, JSONSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        return JsonSerializerFactory.multiTypeSerializer(config, schemas);
    }

    public static <T> Serializer<T> jsonMultiTypeDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, JSONSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        return JsonSerializerFactory.multiTypeDeserializer(config, schemas);
    }

    public static <T> Serializer<Either<T, WithSchema<JsonNode>>> jsonTypedOrGenericDeserializer(@NonNull SerializerConfig config, @NonNull Map<Class<? extends T>, JSONSchema<T>> schemas) {
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        if (schemas == null) {
            throw new NullPointerException("schemas is marked @NonNull but is null");
        }
        Preconditions.checkArgument(config.isWriteEncodingHeader(), "Events should be tagged with encoding ids.");
        String groupId = config.getGroupId();
        SchemaRegistryClient schemaRegistryClient = SerializerFactoryHelper.initForDeserializer(config);
        EncodingCache encodingCache = new EncodingCache(groupId, schemaRegistryClient);
        Map deserializerMap = schemas.values().stream().collect(Collectors.toMap(x -> x.getSchemaInfo().getType(), x -> new JsonDeserializer(groupId, schemaRegistryClient, x, config.getDecoders(), encodingCache, config.isWriteEncodingHeader())));
        JsonWithSchemaDeserializer genericDeserializer = new JsonWithSchemaDeserializer(groupId, schemaRegistryClient, config.getDecoders(), encodingCache, config.isWriteEncodingHeader());
        return new MultiplexedAndGenericDeserializer(groupId, schemaRegistryClient, deserializerMap, genericDeserializer, config.getDecoders(), encodingCache);
    }

    public static <T> Serializer<T> customSerializer(SerializerConfig config, Schema<T> schema, CustomSerializer<T> serializer) {
        return CustomSerializerFactory.serializer(config, schema, serializer);
    }

    public static <T> Serializer<T> customDeserializer(SerializerConfig config, @Nullable Schema<T> schema, CustomDeserializer<T> deserializer) {
        return CustomSerializerFactory.deserializer(config, schema, deserializer);
    }

    public static Serializer<WithSchema<Object>> serializerWithSchema(SerializerConfig config) {
        return MultiFormatSerializerFactory.serializer(config);
    }

    public static Serializer<WithSchema<Object>> deserializerWithSchema(SerializerConfig config) {
        return MultiFormatSerializerFactory.deserializerWithSchema(config);
    }

    public static Serializer<Object> genericDeserializer(SerializerConfig config) {
        return SerializerFactory.deserializeAsT(config, WithSchema.NO_TRANSFORM);
    }

    public static Serializer<String> deserializeAsJsonString(SerializerConfig config) {
        return SerializerFactory.deserializeAsT(config, WithSchema.JSON_TRANSFORM);
    }

    public static <T> Serializer<T> deserializeAsT(SerializerConfig config, BiFunction<SerializationFormat, Object, T> transform) {
        return MultiFormatSerializerFactory.deserializeAsT(config, transform);
    }
}

