/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.serializers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import io.pravega.schemaregistry.contract.data.SchemaInfo;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.protobuf.schemas.ProtobufSchema;
import java.util.function.BiFunction;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;

public class WithSchema<T> {
    public static final BiFunction<SerializationFormat, Object, String> JSON_TRANSFORM = WithSchema::toJsonString;
    public static final BiFunction<SerializationFormat, Object, Object> NO_TRANSFORM = (x, y) -> y;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonFormat.Printer PRINTER = JsonFormat.printer().preservingProtoFieldNames().usingTypeRegistry(JsonFormat.TypeRegistry.newBuilder().build());
    private final io.pravega.schemaregistry.serializer.shared.schemas.Schema schema;
    private final Object object;
    private final BiFunction<SerializationFormat, Object, T> transform;

    WithSchema(SchemaInfo schemaInfo, Object obj, BiFunction<SerializationFormat, Object, T> transform) {
        this.object = obj;
        this.transform = transform;
        this.schema = schemaInfo != null ? this.convertToSchema(schemaInfo) : null;
    }

    private io.pravega.schemaregistry.serializer.shared.schemas.Schema convertToSchema(final SchemaInfo schemaInfo) {
        io.pravega.schemaregistry.serializer.shared.schemas.Schema<Object> schema;
        switch (schemaInfo.getSerializationFormat()) {
            case Avro: {
                schema = AvroSchema.from(schemaInfo);
                break;
            }
            case Protobuf: {
                schema = ProtobufSchema.from(schemaInfo);
                break;
            }
            case Json: {
                schema = JSONSchema.from(schemaInfo);
                break;
            }
            case Custom: {
                schema = new io.pravega.schemaregistry.serializer.shared.schemas.Schema<Object>(){

                    @Override
                    public SchemaInfo getSchemaInfo() {
                        return schemaInfo;
                    }

                    @Override
                    public Class<Object> getTClass() {
                        return Object.class;
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Serialization format not supported");
            }
        }
        return schema;
    }

    public boolean hasAvroSchema() {
        return this.schema instanceof AvroSchema;
    }

    public Schema getAvroSchema() {
        return ((AvroSchema)this.schema).getSchema();
    }

    public boolean hasProtobufSchema() {
        return this.schema instanceof ProtobufSchema;
    }

    public DescriptorProtos.FileDescriptorSet getProtobufSchema() {
        return ((ProtobufSchema)this.schema).getFileDescriptorSet();
    }

    public boolean hasJsonSchema() {
        return this.schema instanceof JSONSchema;
    }

    public org.everit.json.schema.Schema getJsonSchema() {
        return ((JSONSchema)this.schema).getSchema();
    }

    public T getTransformed() {
        if (this.schema == null) {
            throw new IllegalArgumentException("Need schema to be able to transform.");
        }
        return this.transform.apply(this.schema.getSchemaInfo().getSerializationFormat(), this.object);
    }

    public String getJsonString() {
        if (this.schema == null) {
            throw new IllegalArgumentException();
        }
        return JSON_TRANSFORM.apply(this.schema.getSchemaInfo().getSerializationFormat(), this.object);
    }

    private static String toJsonString(SerializationFormat format, Object deserialize) {
        String jsonString;
        try {
            switch (format) {
                case Avro: {
                    if (deserialize instanceof IndexedRecord) {
                        jsonString = deserialize.toString();
                        break;
                    }
                    jsonString = OBJECT_MAPPER.writeValueAsString(deserialize);
                    break;
                }
                case Protobuf: {
                    jsonString = PRINTER.print((DynamicMessage)deserialize);
                    break;
                }
                case Json: {
                    if (deserialize instanceof WithSchema) {
                        jsonString = OBJECT_MAPPER.writeValueAsString(((WithSchema)deserialize).object);
                        break;
                    }
                    jsonString = OBJECT_MAPPER.writeValueAsString(deserialize);
                    break;
                }
                default: {
                    jsonString = OBJECT_MAPPER.writeValueAsString(deserialize);
                    break;
                }
            }
        }
        catch (JsonProcessingException | InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid deserialized object. Failed to convert to json string.", e);
        }
        return jsonString;
    }

    public static <T> WithSchema<T> avro(T object, AvroSchema<T> avroSchema) {
        Preconditions.checkNotNull(object, "object cannot be null");
        Preconditions.checkNotNull(avroSchema, "schema cannot be null");
        return new WithSchema<Object>(avroSchema.getSchemaInfo(), object, (x, y) -> object);
    }

    public static <T extends GeneratedMessageV3> WithSchema<T> proto(T object, ProtobufSchema<T> protobufSchema) {
        Preconditions.checkNotNull(object, "object cannot be null");
        Preconditions.checkNotNull(protobufSchema, "schema cannot be null");
        return new WithSchema<GeneratedMessageV3>(protobufSchema.getSchemaInfo(), object, (x, y) -> object);
    }

    public static <T> WithSchema<T> json(T object, JSONSchema<T> jsonSchema) {
        Preconditions.checkNotNull(object, "object cannot be null");
        Preconditions.checkNotNull(jsonSchema, "schema cannot be null");
        return new WithSchema<Object>(jsonSchema.getSchemaInfo(), object, (x, y) -> object);
    }

    io.pravega.schemaregistry.serializer.shared.schemas.Schema getSchema() {
        return this.schema;
    }

    public Object getObject() {
        return this.object;
    }
}

