/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.tracing;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.pravega.common.tracing.RequestTag;
import io.pravega.common.tracing.RequestTracker;
import io.pravega.common.tracing.TagLogger;
import org.slf4j.LoggerFactory;

public final class RPCTracingHelpers {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(RPCTracingHelpers.class));
    private static final String REQUEST_DESCRIPTOR = "requestDescriptor";
    private static final String REQUEST_ID = "requestId";
    public static final CallOptions.Key<String> REQUEST_DESCRIPTOR_CALL_OPTION = CallOptions.Key.createWithDefault("requestDescriptor", "");
    public static final CallOptions.Key<String> REQUEST_ID_CALL_OPTION = CallOptions.Key.createWithDefault("requestId", "");
    static final Metadata.Key<String> DESCRIPTOR_HEADER = Metadata.Key.of("requestDescriptor", Metadata.ASCII_STRING_MARSHALLER);
    static final Metadata.Key<String> ID_HEADER = Metadata.Key.of("requestId", Metadata.ASCII_STRING_MARSHALLER);

    public static ClientInterceptor getClientInterceptor() {
        return new TaggingClientInterceptor();
    }

    public static ServerInterceptor getServerInterceptor(RequestTracker requestTracker) {
        return new TaggingServerInterceptor(requestTracker);
    }

    @VisibleForTesting
    static String toSanitizedString(Metadata headers) {
        return headers == null ? "null" : headers.toString().replaceAll("authorization=.*(?=,)|authorization=.*(?=\\))", "authorization=xxxxx");
    }

    private static class TaggingServerInterceptor
    implements ServerInterceptor {
        private final RequestTracker requestTracker;

        public TaggingServerInterceptor(RequestTracker requestTracker) {
            this.requestTracker = requestTracker;
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            if (headers != null && headers.containsKey(DESCRIPTOR_HEADER) && headers.containsKey(ID_HEADER)) {
                RequestTag requestTag = new RequestTag(headers.get(DESCRIPTOR_HEADER), Long.parseLong(headers.get(ID_HEADER)));
                this.requestTracker.trackRequest(requestTag);
                log.debug(requestTag.getRequestId(), "Received tag from RPC request {}.", requestTag.getRequestDescriptor());
            } else {
                log.debug("No tags provided for call {} in headers: {}.", (Object)call.getMethodDescriptor().getFullMethodName(), (Object)RPCTracingHelpers.toSanitizedString(headers));
            }
            return next.startCall(new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                @Override
                public void sendHeaders(Metadata responseHeaders) {
                    super.sendHeaders(responseHeaders);
                }
            }, headers);
        }
    }

    private static class TaggingClientInterceptor
    implements ClientInterceptor {
        private TaggingClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    String requestDescriptor = callOptions.getOption(REQUEST_DESCRIPTOR_CALL_OPTION);
                    String requestId = callOptions.getOption(REQUEST_ID_CALL_OPTION);
                    if (requestDescriptor != null && requestId != null && !requestDescriptor.isEmpty() && !requestId.isEmpty()) {
                        headers.put(DESCRIPTOR_HEADER, requestDescriptor);
                        headers.put(ID_HEADER, requestId);
                        log.debug(Long.parseLong(requestId), "Tagging RPC request {}.", requestDescriptor);
                    } else {
                        log.debug("Request not tagged {}: Call options not containing request tags.", (Object)method.getFullMethodName());
                    }
                    super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onHeaders(Metadata headers) {
                            super.onHeaders(headers);
                        }
                    }, headers);
                }
            };
        }
    }
}

