/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.MultiKeyLatestItemSequentialProcessor;
import io.pravega.shared.metrics.ClientMetricKeys;
import io.pravega.shared.metrics.MetricListener;
import io.pravega.shared.metrics.MetricNotifier;
import java.util.concurrent.ScheduledExecutorService;

public class ClientMetricUpdater
implements MetricNotifier {
    private final MultiKeyLatestItemSequentialProcessor<String, Long> successProcessor;
    private final MultiKeyLatestItemSequentialProcessor<String, Long> failureProcessor;
    private final ScheduledExecutorService clientMetricExecutor = ExecutorServiceHelpers.newScheduledThreadPool(1, "clientMetrics");

    public ClientMetricUpdater(MetricListener metricListener) {
        Preconditions.checkNotNull(metricListener);
        this.successProcessor = new MultiKeyLatestItemSequentialProcessor<String, Long>(metricListener::reportSuccessValue, this.clientMetricExecutor);
        this.failureProcessor = new MultiKeyLatestItemSequentialProcessor<String, Long>(metricListener::reportFailValue, this.clientMetricExecutor);
    }

    @Override
    public void updateSuccessMetric(ClientMetricKeys metricKey, String[] metricTags, long value) {
        this.successProcessor.updateItem(metricKey.metric(metricTags), value);
    }

    @Override
    public void updateFailureMetric(ClientMetricKeys metricKey, String[] metric, long value) {
        this.failureProcessor.updateItem(metricKey.metric(metric), value);
    }

    @Override
    public void close() {
        ExecutorServiceHelpers.shutdown(this.clientMetricExecutor);
    }
}

