/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.pravega.common.Exceptions;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import lombok.NonNull;

@NotThreadSafe
public class ByteBufWrapper
extends AbstractBufferView
implements BufferView {
    private final ByteBuf buf;

    public ByteBufWrapper(@NonNull ByteBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        this.buf = buf.asReadOnly();
    }

    @Override
    public void retain() {
        this.buf.retain();
    }

    @Override
    public void release() {
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    @Override
    public List<ByteBuffer> getContents() {
        return Arrays.asList(this.buf.nioBuffers());
    }

    @Override
    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        for (ByteBuffer bb : this.buf.duplicate().nioBuffers()) {
            bufferCollector.accept(bb);
        }
    }

    @Override
    public int getLength() {
        return this.buf.readableBytes();
    }

    @Override
    public BufferView.Reader getBufferViewReader() {
        return new ByteBufReader(this.buf.duplicate());
    }

    @Override
    public InputStream getReader() {
        Exceptions.checkNotClosed(this.buf.refCnt() == 0, this);
        return new ByteBufInputStream(this.buf.duplicate(), false);
    }

    @Override
    public InputStream getReader(int offset, int length) {
        Exceptions.checkNotClosed(this.buf.refCnt() == 0, this);
        return new ByteBufInputStream(this.buf.slice(offset, length), false);
    }

    @Override
    public BufferView slice(int offset, int length) {
        Exceptions.checkNotClosed(this.buf.refCnt() == 0, this);
        return new ByteBufWrapper(this.buf.slice(offset, length));
    }

    @Override
    public byte[] getCopy() {
        Exceptions.checkNotClosed(this.buf.refCnt() == 0, this);
        ByteBuf buf = this.buf.duplicate();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    @Override
    public void copyTo(OutputStream target) throws IOException {
        Exceptions.checkNotClosed(this.buf.refCnt() == 0, this);
        ByteBuf buf = this.buf.duplicate();
        buf.readBytes(target, buf.readableBytes());
    }

    @Override
    public int copyTo(ByteBuffer byteBuffer) {
        Exceptions.checkNotClosed(this.buf.refCnt() == 0, this);
        ByteBuf source = this.buf.duplicate();
        int length = byteBuffer.remaining();
        if (length > this.getLength()) {
            int origLimit = byteBuffer.limit();
            length = this.getLength();
            byteBuffer.limit(byteBuffer.position() + length);
            source.readBytes(byteBuffer);
            byteBuffer.limit(origLimit);
        } else {
            source.readBytes(byteBuffer);
        }
        return length;
    }

    public String toString() {
        return this.buf.toString();
    }

    private static class ByteBufReader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private final ByteBuf buf;

        @Override
        public int available() {
            return this.buf.readableBytes();
        }

        @Override
        public int readBytes(ByteArraySegment segment) {
            int len = Math.min(segment.getLength(), this.buf.readableBytes());
            if (len > 0) {
                this.buf.readBytes(segment.array(), segment.arrayOffset(), len);
            }
            return len;
        }

        @Override
        public byte readByte() {
            try {
                return this.buf.readByte();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @Override
        public int readInt() {
            try {
                return this.buf.readInt();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @Override
        public long readLong() {
            try {
                return this.buf.readLong();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @Override
        public BufferView readSlice(int length) {
            try {
                return new ByteBufWrapper(this.buf.readSlice(length));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @ConstructorProperties(value={"buf"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBufReader(ByteBuf buf) {
            this.buf = buf;
        }
    }
}

