/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.watermarks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.IOException;
import lombok.Generated;

public class SegmentWithRange {
    static final SegmentWithRangeSerializer SERIALIZER = new SegmentWithRangeSerializer();
    private final long segmentId;
    private final double rangeLow;
    private final double rangeHigh;

    public SegmentWithRange(long segmentId, double rangeLow, double rangeHigh) {
        Preconditions.checkArgument(segmentId >= 0L);
        Preconditions.checkArgument(rangeLow >= 0.0);
        Preconditions.checkArgument(rangeHigh <= 1.0);
        Preconditions.checkArgument(rangeLow < rangeHigh);
        this.segmentId = segmentId;
        this.rangeLow = rangeLow;
        this.rangeHigh = rangeHigh;
    }

    public boolean overlaps(SegmentWithRange segment) {
        return segment.getRangeLow() < this.rangeHigh && segment.getRangeHigh() > this.rangeLow;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SegmentWithRangeBuilder builder() {
        return new SegmentWithRangeBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSegmentId() {
        return this.segmentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getRangeLow() {
        return this.rangeLow;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getRangeHigh() {
        return this.rangeHigh;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentWithRange)) {
            return false;
        }
        SegmentWithRange other = (SegmentWithRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSegmentId() != other.getSegmentId()) {
            return false;
        }
        if (Double.compare(this.getRangeLow(), other.getRangeLow()) != 0) {
            return false;
        }
        return Double.compare(this.getRangeHigh(), other.getRangeHigh()) == 0;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentWithRange;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $segmentId = this.getSegmentId();
        result = result * 59 + (int)($segmentId >>> 32 ^ $segmentId);
        long $rangeLow = Double.doubleToLongBits(this.getRangeLow());
        result = result * 59 + (int)($rangeLow >>> 32 ^ $rangeLow);
        long $rangeHigh = Double.doubleToLongBits(this.getRangeHigh());
        result = result * 59 + (int)($rangeHigh >>> 32 ^ $rangeHigh);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SegmentWithRange(segmentId=" + this.getSegmentId() + ", rangeLow=" + this.getRangeLow() + ", rangeHigh=" + this.getRangeHigh() + ")";
    }

    static class SegmentWithRangeSerializer
    extends VersionedSerializer.WithBuilder<SegmentWithRange, SegmentWithRangeBuilder> {
        SegmentWithRangeSerializer() {
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, SegmentWithRangeBuilder builder) throws IOException {
            builder.segmentId(revisionDataInput.readLong());
            builder.rangeLow(revisionDataInput.readDouble());
            builder.rangeHigh(revisionDataInput.readDouble());
        }

        private void write00(SegmentWithRange segmentWithRange, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(segmentWithRange.segmentId);
            revisionDataOutput.writeDouble(segmentWithRange.rangeLow);
            revisionDataOutput.writeDouble(segmentWithRange.rangeHigh);
        }

        @Override
        protected SegmentWithRangeBuilder newBuilder() {
            return SegmentWithRange.builder();
        }
    }

    public static class SegmentWithRangeBuilder
    implements ObjectBuilder<SegmentWithRange> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long segmentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double rangeLow;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double rangeHigh;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SegmentWithRangeBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentWithRangeBuilder segmentId(long segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentWithRangeBuilder rangeLow(double rangeLow) {
            this.rangeLow = rangeLow;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentWithRangeBuilder rangeHigh(double rangeHigh) {
            this.rangeHigh = rangeHigh;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentWithRange build() {
            return new SegmentWithRange(this.segmentId, this.rangeLow, this.rangeHigh);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SegmentWithRange.SegmentWithRangeBuilder(segmentId=" + this.segmentId + ", rangeLow=" + this.rangeLow + ", rangeHigh=" + this.rangeHigh + ")";
        }
    }
}

