/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.accumulo.AccumuloClient;
import io.prestosql.plugin.accumulo.model.AccumuloColumnConstraint;
import io.prestosql.plugin.accumulo.model.AccumuloColumnHandle;
import io.prestosql.plugin.accumulo.model.AccumuloSplit;
import io.prestosql.plugin.accumulo.model.AccumuloTableHandle;
import io.prestosql.plugin.accumulo.model.AccumuloTableLayoutHandle;
import io.prestosql.plugin.accumulo.model.TabletSplitMetadata;
import io.prestosql.plugin.accumulo.model.WrappedRange;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AccumuloSplitManager
implements ConnectorSplitManager {
    private final AccumuloClient client;

    @Inject
    public AccumuloSplitManager(AccumuloClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        AccumuloTableLayoutHandle layoutHandle = (AccumuloTableLayoutHandle)layout;
        AccumuloTableHandle tableHandle = layoutHandle.getTable();
        String schemaName = tableHandle.getSchema();
        String tableName = tableHandle.getTable();
        String rowIdName = tableHandle.getRowId();
        List<AccumuloColumnConstraint> constraints = AccumuloSplitManager.getColumnConstraints(rowIdName, layoutHandle.getConstraint());
        Optional<Domain> rDom = AccumuloSplitManager.getRangeDomain(rowIdName, layoutHandle.getConstraint());
        List<TabletSplitMetadata> tabletSplits = this.client.getTabletSplits(session, schemaName, tableName, rDom, constraints, tableHandle.getSerializerInstance());
        ImmutableList.Builder cSplits = ImmutableList.builder();
        for (TabletSplitMetadata splitMetadata : tabletSplits) {
            AccumuloSplit split = new AccumuloSplit(splitMetadata.getRanges().stream().map(WrappedRange::new).collect(Collectors.toList()), constraints, splitMetadata.getHostPort());
            cSplits.add((Object)split);
        }
        return new FixedSplitSource((Iterable)cSplits.build());
    }

    private static Optional<Domain> getRangeDomain(String rowIdName, TupleDomain<ColumnHandle> constraint) {
        if (constraint.getColumnDomains().isPresent()) {
            for (TupleDomain.ColumnDomain cd : (List)constraint.getColumnDomains().get()) {
                AccumuloColumnHandle col = (AccumuloColumnHandle)cd.getColumn();
                if (!col.getName().equals(rowIdName)) continue;
                return Optional.of(cd.getDomain());
            }
        }
        return Optional.empty();
    }

    private static List<AccumuloColumnConstraint> getColumnConstraints(String rowIdName, TupleDomain<ColumnHandle> constraint) {
        ImmutableList.Builder constraintBuilder = ImmutableList.builder();
        for (TupleDomain.ColumnDomain columnDomain : (List)constraint.getColumnDomains().get()) {
            AccumuloColumnHandle columnHandle = (AccumuloColumnHandle)columnDomain.getColumn();
            if (columnHandle.getName().equals(rowIdName)) continue;
            constraintBuilder.add((Object)new AccumuloColumnConstraint(columnHandle.getName(), columnHandle.getFamily().get(), columnHandle.getQualifier().get(), Optional.of(columnDomain.getDomain()), columnHandle.isIndexed()));
        }
        return constraintBuilder.build();
    }
}

