/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo;

import io.airlift.log.Logger;
import io.prestosql.plugin.accumulo.AccumuloErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.hadoop.io.Text;

public class AccumuloTableManager {
    private static final Logger LOG = Logger.get(AccumuloTableManager.class);
    private static final String DEFAULT = "default";
    private final Connector connector;

    @Inject
    public AccumuloTableManager(Connector connector) {
        this.connector = Objects.requireNonNull(connector, "connector is null");
    }

    public void ensureNamespace(String schema) {
        try {
            if (!schema.equals(DEFAULT) && !this.connector.namespaceOperations().exists(schema)) {
                this.connector.namespaceOperations().create(schema);
            }
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to check for existence or create Accumulo namespace", e);
        }
        catch (NamespaceExistsException e) {
            LOG.warn("NamespaceExistsException suppressed when creating " + schema);
        }
    }

    public boolean exists(String table) {
        return this.connector.tableOperations().exists(table);
    }

    public void createAccumuloTable(String table) {
        try {
            this.connector.tableOperations().create(table);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to create Accumulo table", e);
        }
        catch (TableExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_EXISTS, "Accumulo table already exists", (Throwable)e);
        }
    }

    public void setLocalityGroups(String tableName, Map<String, Set<Text>> groups) {
        if (groups.isEmpty()) {
            return;
        }
        try {
            this.connector.tableOperations().setLocalityGroups(tableName, groups);
            LOG.debug("Set locality groups for %s to %s", new Object[]{tableName, groups});
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to set locality groups", e);
        }
        catch (TableNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to set locality groups, table does not exist", (Throwable)e);
        }
    }

    public void setIterator(String table, IteratorSetting setting) {
        try {
            Map iterators = this.connector.tableOperations().listIterators(table);
            if (iterators.containsKey(setting.getName())) {
                this.connector.tableOperations().removeIterator(table, setting.getName(), (EnumSet)iterators.get(setting.getName()));
            }
            this.connector.tableOperations().attachIterator(table, setting);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to set iterator on table " + table, e);
        }
        catch (TableNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to set iterator, table does not exist", (Throwable)e);
        }
    }

    public void deleteAccumuloTable(String tableName) {
        try {
            this.connector.tableOperations().delete(tableName);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to delete Accumulo table", e);
        }
        catch (TableNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to delete Accumulo table, does not exist", (Throwable)e);
        }
    }

    public void renameAccumuloTable(String oldName, String newName) {
        try {
            this.connector.tableOperations().rename(oldName, newName);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to rename table", e);
        }
        catch (TableNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to rename table, old table does not exist", (Throwable)e);
        }
        catch (TableExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_EXISTS, "Failed to rename table, new table already exists", (Throwable)e);
        }
    }
}

