/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo.io;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.prestosql.plugin.accumulo.AccumuloErrorCode;
import io.prestosql.plugin.accumulo.conf.AccumuloSessionProperties;
import io.prestosql.plugin.accumulo.io.AccumuloRecordCursor;
import io.prestosql.plugin.accumulo.model.AccumuloColumnConstraint;
import io.prestosql.plugin.accumulo.model.AccumuloColumnHandle;
import io.prestosql.plugin.accumulo.model.AccumuloSplit;
import io.prestosql.plugin.accumulo.model.AccumuloTableHandle;
import io.prestosql.plugin.accumulo.serializers.AccumuloRowSerializer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.Authorizations;

public class AccumuloRecordSet
implements RecordSet {
    private static final Logger LOG = Logger.get(AccumuloRecordSet.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final List<AccumuloColumnHandle> columnHandles;
    private final List<AccumuloColumnConstraint> constraints;
    private final List<Type> columnTypes;
    private final AccumuloRowSerializer serializer;
    private final BatchScanner scanner;
    private final String rowIdName;

    public AccumuloRecordSet(Connector connector, ConnectorSession session, AccumuloSplit split, String username, AccumuloTableHandle table, List<AccumuloColumnHandle> columnHandles) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(username, "username is null");
        this.constraints = Objects.requireNonNull(split.getConstraints(), "constraints is null");
        this.rowIdName = table.getRowId();
        this.serializer = table.getSerializerInstance();
        this.columnHandles = Objects.requireNonNull(columnHandles, "column handles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (AccumuloColumnHandle column : columnHandles) {
            types.add((Object)column.getType());
        }
        this.columnTypes = types.build();
        try {
            this.scanner = connector.createBatchScanner(table.getFullTableName(), AccumuloRecordSet.getScanAuthorizations(session, table, connector, username), 10);
            this.scanner.setRanges(split.getRanges());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, String.format("Failed to create batch scanner for table %s", table.getFullTableName()), (Throwable)e);
        }
    }

    private static Authorizations getScanAuthorizations(ConnectorSession session, AccumuloTableHandle table, Connector connector, String username) throws AccumuloException, AccumuloSecurityException {
        String sessionScanUser = AccumuloSessionProperties.getScanUsername(session);
        if (sessionScanUser != null) {
            Authorizations scanAuths = connector.securityOperations().getUserAuthorizations(sessionScanUser);
            LOG.debug("Using session scanner auths for user %s: %s", new Object[]{sessionScanUser, scanAuths});
            return scanAuths;
        }
        Optional<String> scanAuths = table.getScanAuthorizations();
        if (scanAuths.isPresent()) {
            Authorizations auths = new Authorizations((String[])Iterables.toArray((Iterable)COMMA_SPLITTER.split((CharSequence)scanAuths.get()), String.class));
            LOG.debug("scan_auths table property set: %s", new Object[]{auths});
            return auths;
        }
        Authorizations auths = connector.securityOperations().getUserAuthorizations(username);
        LOG.debug("scan_auths table property not set, using user auths: %s", new Object[]{auths});
        return auths;
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new AccumuloRecordCursor(this.serializer, this.scanner, this.rowIdName, this.columnHandles, this.constraints);
    }
}

