/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo.io;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.accumulo.conf.AccumuloConfig;
import io.prestosql.plugin.accumulo.io.AccumuloRecordSet;
import io.prestosql.plugin.accumulo.model.AccumuloColumnHandle;
import io.prestosql.plugin.accumulo.model.AccumuloSplit;
import io.prestosql.plugin.accumulo.model.AccumuloTableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.accumulo.core.client.Connector;

public class AccumuloRecordSetProvider
implements ConnectorRecordSetProvider {
    private final Connector connector;
    private final String username;

    @Inject
    public AccumuloRecordSetProvider(Connector connector, AccumuloConfig config) {
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.username = Objects.requireNonNull(config, "config is null").getUsername();
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        AccumuloSplit accSplit = (AccumuloSplit)split;
        AccumuloTableHandle accTable = (AccumuloTableHandle)table;
        List accColumns = (List)columns.stream().map(AccumuloColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new AccumuloRecordSet(this.connector, session, accSplit, this.username, accTable, accColumns);
    }
}

