/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.accumulo.model.AccumuloColumnConstraint;
import io.prestosql.plugin.accumulo.model.WrappedRange;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.Range;

public class AccumuloSplit
implements ConnectorSplit {
    private final Optional<String> hostPort;
    private final List<HostAddress> addresses;
    private final List<AccumuloColumnConstraint> constraints;
    private final List<WrappedRange> ranges;

    @JsonCreator
    public AccumuloSplit(@JsonProperty(value="ranges") List<WrappedRange> ranges, @JsonProperty(value="constraints") List<AccumuloColumnConstraint> constraints, @JsonProperty(value="hostPort") Optional<String> hostPort) {
        this.constraints = ImmutableList.copyOf((Collection)Objects.requireNonNull(constraints, "constraints is null"));
        this.hostPort = Objects.requireNonNull(hostPort, "hostPort is null");
        this.ranges = ImmutableList.copyOf((Collection)Objects.requireNonNull(ranges, "ranges is null"));
        this.addresses = hostPort.isPresent() ? ImmutableList.of((Object)HostAddress.fromString((String)hostPort.get())) : ImmutableList.of();
    }

    @JsonProperty
    public Optional<String> getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="ranges")
    public List<WrappedRange> getWrappedRanges() {
        return this.ranges;
    }

    @JsonIgnore
    public List<Range> getRanges() {
        return this.ranges.stream().map(WrappedRange::getRange).collect(Collectors.toList());
    }

    @JsonProperty
    public List<AccumuloColumnConstraint> getConstraints() {
        return this.constraints;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", this.addresses).add("numRanges", this.ranges.size()).add("constraints", this.constraints).add("hostPort", this.hostPort).toString();
    }
}

