/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.plugin.accumulo.metadata.AccumuloTable;
import io.prestosql.plugin.accumulo.serializers.AccumuloRowSerializer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;
import java.util.Optional;

public final class AccumuloTableHandle
implements ConnectorInsertTableHandle,
ConnectorOutputTableHandle,
ConnectorTableHandle {
    private final boolean external;
    private final String rowId;
    private final Optional<String> scanAuthorizations;
    private final String schema;
    private final String serializerClassName;
    private final String table;

    @JsonCreator
    public AccumuloTableHandle(@JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="rowId") String rowId, @JsonProperty(value="external") boolean external, @JsonProperty(value="serializerClassName") String serializerClassName, @JsonProperty(value="scanAuthorizations") Optional<String> scanAuthorizations) {
        this.external = external;
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.scanAuthorizations = scanAuthorizations;
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.serializerClassName = Objects.requireNonNull(serializerClassName, "serializerClassName is null");
        this.table = Objects.requireNonNull(table, "table is null");
    }

    @JsonProperty
    public String getRowId() {
        return this.rowId;
    }

    @JsonProperty
    public Optional<String> getScanAuthorizations() {
        return this.scanAuthorizations;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    @JsonIgnore
    public AccumuloRowSerializer getSerializerInstance() {
        try {
            return (AccumuloRowSerializer)Class.forName(this.serializerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Configured serializer class not found", (Throwable)e);
        }
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public boolean isExternal() {
        return this.external;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schema, this.table);
    }

    @JsonIgnore
    public String getFullTableName() {
        return AccumuloTable.getFullTableName(this.schema, this.table);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.table, this.rowId, this.external, this.serializerClassName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccumuloTableHandle other = (AccumuloTableHandle)obj;
        return Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table) && Objects.equals(this.rowId, other.rowId) && Objects.equals(this.external, other.external) && Objects.equals(this.serializerClassName, other.serializerClassName) && Objects.equals(this.scanAuthorizations, other.scanAuthorizations);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", (Object)this.schema).add("table", (Object)this.table).add("rowId", (Object)this.rowId).add("internal", this.external).add("serializerClassName", (Object)this.serializerClassName).add("scanAuthorizations", this.scanAuthorizations).toString();
    }
}

