/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.accumulo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.data.Range;

public class TabletSplitMetadata {
    private final Optional<String> hostPort;
    private final List<Range> ranges;

    @JsonCreator
    public TabletSplitMetadata(@JsonProperty(value="hostPort") Optional<String> hostPort, @JsonProperty(value="ranges") List<Range> ranges) {
        this.hostPort = Objects.requireNonNull(hostPort, "hostPort is null");
        this.ranges = ImmutableList.copyOf((Collection)Objects.requireNonNull(ranges, "ranges is null"));
    }

    @JsonProperty
    public Optional<String> getHostPort() {
        return this.hostPort;
    }

    @JsonProperty
    public List<Range> getRanges() {
        return this.ranges;
    }

    public int hashCode() {
        return Objects.hash(this.hostPort, this.ranges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TabletSplitMetadata other = (TabletSplitMetadata)obj;
        return Objects.equals(this.hostPort, other.hostPort) && Objects.equals(this.ranges, other.ranges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostPort", this.hostPort).add("numRanges", this.ranges.size()).toString();
    }
}

