/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkCPUCounters {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final int ITERATIONS = 1000;

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public void nanoTime(Blackhole blackhole) {
        for (int i = 0; i < 1000; ++i) {
            blackhole.consume(System.nanoTime());
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public void cpuTime(Blackhole blackhole) {
        for (int i = 0; i < 1000; ++i) {
            blackhole.consume(BenchmarkCPUCounters.currentThreadCpuTime());
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public void userTime(Blackhole blackhole) {
        for (int i = 0; i < 1000; ++i) {
            blackhole.consume(BenchmarkCPUCounters.currentThreadUserTime());
        }
    }

    private static long currentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long currentThreadUserTime() {
        return THREAD_MX_BEAN.getCurrentThreadUserTime();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).threads(Integer.getInteger("threads", 1).intValue()).include(".*" + BenchmarkCPUCounters.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

