/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import io.prestosql.benchmark.MemoryLocalQueryRunner;
import io.prestosql.spi.Page;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkDecimalAggregation {
    @Benchmark
    public List<Page> benchmarkBuildHash(AggregationContext context) {
        return context.getQueryRunner().execute(String.format("SELECT %s FROM orders GROUP BY orderstatus", context.project));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkDecimalAggregation.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class AggregationContext {
        @Param(value={"orderstatus, avg(totalprice)", "orderstatus, min(totalprice)", "orderstatus, sum(totalprice), avg(totalprice), min(totalprice), max(totalprice)"})
        private String project;
        @Param(value={"double", "decimal(14,2)", "decimal(30,10)"})
        private String type;
        private MemoryLocalQueryRunner queryRunner;

        public final MemoryLocalQueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        @Setup
        public void setUp() {
            this.queryRunner = new MemoryLocalQueryRunner();
            this.queryRunner.execute(String.format("CREATE TABLE memory.default.orders AS SELECT orderstatus, cast(totalprice as %s) totalprice FROM tpch.sf1.orders", this.type));
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }
}

