/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableMap;
import io.prestosql.benchmark.MemoryLocalQueryRunner;
import io.prestosql.spi.Page;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkInequalityJoin {
    @Benchmark
    public List<Page> benchmarkJoin(Context context) {
        return context.getQueryRunner().execute("SELECT count(*) FROM t1 JOIN t2 on (t1.bucket = t2.bucket) WHERE t1.val1 < t2.val2");
    }

    @Benchmark
    public List<Page> benchmarkJoinWithArithmeticInPredicate(Context context) {
        return context.getQueryRunner().execute("SELECT count(*) FROM t1 JOIN t2 on (t1.bucket = t2.bucket) AND t1.val1 < t2.val2 + 10");
    }

    @Benchmark
    public List<Page> benchmarkJoinWithFunctionPredicate(Context context) {
        return context.getQueryRunner().execute("SELECT count(*) FROM t1 JOIN t2 on (t1.bucket = t2.bucket) AND t1.val1 < sin(t2.val2)");
    }

    @Benchmark
    public List<Page> benchmarkRangePredicateJoin(Context context) {
        return context.getQueryRunner().execute("SELECT count(*) FROM t1 JOIN t2 on (t1.bucket = t2.bucket) AND t1.val1 + 1 < t2.val2 AND t2.val2 < t1.val1 + 5 ");
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkInequalityJoin.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        private MemoryLocalQueryRunner queryRunner;
        @Param(value={"true", "false"})
        private String fastInequalityJoins;
        @Param(value={"100", "1000", "10000", "60000"})
        private int buckets;
        @Param(value={"10"})
        private int filterOutCoefficient;

        public MemoryLocalQueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        @Setup
        public void setUp() {
            this.queryRunner = new MemoryLocalQueryRunner((Map<String, String>)ImmutableMap.of((Object)"fast_inequality_joins", (Object)this.fastInequalityJoins));
            this.queryRunner.execute(String.format("CREATE TABLE memory.default.t1 AS SELECT orderkey %% %d bucket, (orderkey * 13) %% 1000 val1 FROM tpch.tiny.lineitem", this.buckets));
            this.queryRunner.execute(String.format("CREATE TABLE memory.default.t2 AS SELECT orderkey %% %d bucket, (orderkey * 379) %% %d val2 FROM tpch.tiny.lineitem", this.buckets, this.filterOutCoefficient));
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }
}

