/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.Driver;
import io.prestosql.operator.OutputFactory;
import io.prestosql.operator.TaskContext;
import io.prestosql.plugin.memory.MemoryConnectorFactory;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.Page;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.PageConsumerOperator;
import io.prestosql.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;

public class MemoryLocalQueryRunner
implements AutoCloseable {
    protected final LocalQueryRunner localQueryRunner;

    public MemoryLocalQueryRunner() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public MemoryLocalQueryRunner(Map<String, String> properties) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("memory").setSchema("default");
        properties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        this.localQueryRunner = MemoryLocalQueryRunner.createMemoryLocalQueryRunner(sessionBuilder.build());
    }

    public void installPlugin(Plugin plugin) {
        this.localQueryRunner.installPlugin(plugin);
    }

    public List<Page> execute(@Language(value="SQL") String query) {
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(2.0, DataSize.Unit.GIGABYTE));
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        QueryContext queryContext = new QueryContext(new QueryId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE), new DataSize(2.0, DataSize.Unit.GIGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.localQueryRunner.getExecutor(), this.localQueryRunner.getScheduler(), new DataSize(4.0, DataSize.Unit.GIGABYTE), spillSpaceTracker);
        TaskContext taskContext = queryContext.addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0), (Executor)this.localQueryRunner.getExecutor()), this.localQueryRunner.getDefaultSession(), false, false, OptionalInt.empty());
        ImmutableList.Builder output = ImmutableList.builder();
        List drivers = this.localQueryRunner.createDrivers(query, (OutputFactory)new PageConsumerOperator.PageConsumerOutputFactory(types -> arg_0 -> ((ImmutableList.Builder)output).add(arg_0)), taskContext);
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.process();
                processed = true;
            }
            done = !processed;
        }
        return output.build();
    }

    private static LocalQueryRunner createMemoryLocalQueryRunner(Session session) {
        LocalQueryRunner localQueryRunner = LocalQueryRunner.queryRunnerWithInitialTransaction((Session)session);
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        localQueryRunner.createCatalog("memory", (ConnectorFactory)new MemoryConnectorFactory(), (Map)ImmutableMap.of((Object)"memory.max-data-per-node", (Object)"4GB"));
        return localQueryRunner;
    }

    public void dropTable(String tableName) {
        Session session = this.localQueryRunner.getDefaultSession();
        Metadata metadata = this.localQueryRunner.getMetadata();
        Optional tableHandle = metadata.getTableHandle(session, QualifiedObjectName.valueOf((String)tableName));
        Assert.assertTrue((boolean)tableHandle.isPresent(), (String)("Table " + tableName + " does not exist"));
        metadata.dropTable(session, (TableHandle)tableHandle.get());
    }

    @Override
    public void close() {
        this.localQueryRunner.close();
    }
}

