/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.benchmark.AbstractOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.operator.Driver;
import io.prestosql.operator.DriverFactory;
import io.prestosql.operator.HashBuilderOperator;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PartitionedLookupSourceFactory;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.NullOutputOperator;
import io.prestosql.testing.TestingSession;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class HashBuildAndJoinBenchmark
extends AbstractOperatorBenchmark {
    private final boolean hashEnabled;
    private final List<Type> ordersTableTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
    private final OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
    private final List<Type> lineItemTableTypes = this.getColumnTypes("lineitem", "orderkey", "quantity");
    private final OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();

    public HashBuildAndJoinBenchmark(Session session, LocalQueryRunner localQueryRunner) {
        super(session, localQueryRunner, "hash_build_and_join_hash_enabled_" + HashBuildAndJoinBenchmark.isHashEnabled(session), 4, 5);
        this.hashEnabled = HashBuildAndJoinBenchmark.isHashEnabled(session);
    }

    private static boolean isHashEnabled(Session session) {
        return SystemSessionProperties.isOptimizeHashGenerationEnabled((Session)session);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        ImmutableList.Builder driversBuilder = ImmutableList.builder();
        driversBuilder.add((Object)this.ordersTableScan);
        Object sourceTypes = this.ordersTableTypes;
        OptionalInt hashChannel = OptionalInt.empty();
        if (this.hashEnabled) {
            driversBuilder.add((Object)this.createHashProjectOperator(1, new PlanNodeId("test"), (List<Type>)sourceTypes));
            sourceTypes = ImmutableList.builder().addAll(sourceTypes).add((Object)BigintType.BIGINT).build();
            hashChannel = OptionalInt.of(sourceTypes.size() - 1);
        }
        JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory((List)sourceTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(arg_0 -> sourceTypes.get(arg_0)).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(((List)sourceTypes)::get).collect(ImmutableList.toImmutableList()), 1, false));
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(2, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), hashChannel, Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory());
        driversBuilder.add((Object)hashBuilder);
        DriverFactory hashBuildDriverFactory = new DriverFactory(0, true, false, (List)driversBuilder.build(), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)this.lineItemTableScan);
        sourceTypes = this.lineItemTableTypes;
        hashChannel = OptionalInt.empty();
        if (this.hashEnabled) {
            joinDriversBuilder.add((Object)this.createHashProjectOperator(1, new PlanNodeId("test"), (List<Type>)sourceTypes));
            sourceTypes = ImmutableList.builder().addAll((Iterable)sourceTypes).add((Object)BigintType.BIGINT).build();
            hashChannel = OptionalInt.of(sourceTypes.size() - 1);
        }
        OperatorFactory joinOperator = LOOKUP_JOIN_OPERATORS.innerJoin(2, new PlanNodeId("test"), lookupSourceFactoryManager, (List)sourceTypes, Ints.asList((int[])new int[]{0}), hashChannel, Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory());
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, new PlanNodeId("test")));
        DriverFactory joinDriverFactory = new DriverFactory(1, true, true, (List)joinDriversBuilder.build(), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(0, true, false, false).addDriverContext());
        hashBuildDriverFactory.noMoreDrivers();
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(1, true, true, false).addDriverContext());
        joinDriverFactory.noMoreDrivers();
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunnerHashEnabled()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

