/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.benchmark.AbstractOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.operator.Driver;
import io.prestosql.operator.DriverFactory;
import io.prestosql.operator.HashBuilderOperator;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PartitionedLookupSourceFactory;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.ValuesOperator;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.NullOutputOperator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class HashBuildBenchmark
extends AbstractOperatorBenchmark {
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();

    public HashBuildBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_build", 4, 5);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        List<Type> ordersTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
        OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
        JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(ordersTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), 1, false));
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory());
        DriverFactory hashBuildDriverFactory = new DriverFactory(0, true, true, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("values"), (List)ImmutableList.of()));
        OperatorFactory joinOperator = LOOKUP_JOIN_OPERATORS.innerJoin(2, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory());
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, new PlanNodeId("test")));
        DriverFactory joinDriverFactory = new DriverFactory(1, true, true, (List)joinDriversBuilder.build(), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        hashBuildDriverFactory.noMoreDrivers();
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(1, true, true, false).addDriverContext());
        joinDriverFactory.noMoreDrivers();
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

