/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.benchmark.AbstractSimpleOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.FilterAndProjectOperator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.testing.LocalQueryRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class PredicateFilterBenchmark
extends AbstractSimpleOperatorBenchmark {
    public PredicateFilterBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "predicate_filter", 5, 50);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "totalprice");
        CallExpression filter = Expressions.call((ResolvedFunction)this.localQueryRunner.getMetadata().resolveOperator(OperatorType.GREATER_THAN_OR_EQUAL, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)DoubleType.DOUBLE), Expressions.constant((Object)50000.0, (Type)DoubleType.DOUBLE)});
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.localQueryRunner.getMetadata(), new PageFunctionCompiler(this.localQueryRunner.getMetadata(), 0));
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)DoubleType.DOUBLE)));
        OperatorFactory filterAndProjectOperator = FilterAndProjectOperator.createOperatorFactory((int)1, (PlanNodeId)new PlanNodeId("test"), (Supplier)pageProcessor, (List)ImmutableList.of((Object)DoubleType.DOUBLE), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        return ImmutableList.of((Object)tableScanOperator, (Object)filterAndProjectOperator);
    }

    public static void main(String[] args) {
        new PredicateFilterBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

