/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.prestosql.Session;
import io.prestosql.benchmark.AbstractBenchmark;
import io.prestosql.benchmark.ArrayComparisonBenchmark;
import io.prestosql.benchmark.BenchmarkResultHook;
import io.prestosql.benchmark.CountAggregationBenchmark;
import io.prestosql.benchmark.CountAggregationSqlBenchmark;
import io.prestosql.benchmark.CountWithFilterSqlBenchmark;
import io.prestosql.benchmark.DoubleSumAggregationBenchmark;
import io.prestosql.benchmark.GroupByAggregationSqlBenchmark;
import io.prestosql.benchmark.GroupBySumWithArithmeticSqlBenchmark;
import io.prestosql.benchmark.HandTpchQuery1;
import io.prestosql.benchmark.HandTpchQuery6;
import io.prestosql.benchmark.HashAggregationBenchmark;
import io.prestosql.benchmark.HashBuildAndJoinBenchmark;
import io.prestosql.benchmark.HashBuildBenchmark;
import io.prestosql.benchmark.HashJoinBenchmark;
import io.prestosql.benchmark.JsonAvgBenchmarkResultWriter;
import io.prestosql.benchmark.JsonBenchmarkResultWriter;
import io.prestosql.benchmark.LongMaxAggregationSqlBenchmark;
import io.prestosql.benchmark.OdsBenchmarkResultWriter;
import io.prestosql.benchmark.OrderByBenchmark;
import io.prestosql.benchmark.PredicateFilterBenchmark;
import io.prestosql.benchmark.PredicateFilterSqlBenchmark;
import io.prestosql.benchmark.RawStreamingBenchmark;
import io.prestosql.benchmark.RawStreamingSqlBenchmark;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.benchmark.SqlApproximateCountDistinctDoubleBenchmark;
import io.prestosql.benchmark.SqlApproximateCountDistinctLongBenchmark;
import io.prestosql.benchmark.SqlApproximateCountDistinctVarBinaryBenchmark;
import io.prestosql.benchmark.SqlApproximatePercentileBenchmark;
import io.prestosql.benchmark.SqlBetweenBenchmark;
import io.prestosql.benchmark.SqlDistinctMultipleFields;
import io.prestosql.benchmark.SqlDistinctSingleField;
import io.prestosql.benchmark.SqlDoubleSumAggregationBenchmark;
import io.prestosql.benchmark.SqlHashJoinBenchmark;
import io.prestosql.benchmark.SqlInBenchmark;
import io.prestosql.benchmark.SqlJoinWithPredicateBenchmark;
import io.prestosql.benchmark.SqlLikeBenchmark;
import io.prestosql.benchmark.SqlRegexpLikeBenchmark;
import io.prestosql.benchmark.SqlSemiJoinInPredicateBenchmark;
import io.prestosql.benchmark.SqlTpchQuery1;
import io.prestosql.benchmark.SqlTpchQuery6;
import io.prestosql.benchmark.StatisticsBenchmark;
import io.prestosql.benchmark.Top100Benchmark;
import io.prestosql.benchmark.Top100SqlBenchmark;
import io.prestosql.benchmark.VarBinaryMaxAggregationSqlBenchmark;
import io.prestosql.testing.LocalQueryRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BenchmarkSuite {
    private static final Logger LOGGER = Logger.get(BenchmarkSuite.class);
    private final LocalQueryRunner localQueryRunner;
    private final String outputDirectory;

    public static List<AbstractBenchmark> createBenchmarks(LocalQueryRunner localQueryRunner) {
        Session optimizeHashSession = Session.builder((Session)localQueryRunner.getDefaultSession()).setSystemProperty("optimize_hash_generation", "true").build();
        return ImmutableList.of((Object)new CountAggregationBenchmark(localQueryRunner), (Object)new DoubleSumAggregationBenchmark(localQueryRunner), (Object)new HashAggregationBenchmark(localQueryRunner), (Object)new PredicateFilterBenchmark(localQueryRunner), (Object)new RawStreamingBenchmark(localQueryRunner), (Object)new Top100Benchmark(localQueryRunner), (Object)new OrderByBenchmark(localQueryRunner), (Object)new HashBuildBenchmark(localQueryRunner), (Object)new HashJoinBenchmark(localQueryRunner), (Object)new HashBuildAndJoinBenchmark(localQueryRunner.getDefaultSession(), localQueryRunner), (Object)new HashBuildAndJoinBenchmark(optimizeHashSession, localQueryRunner), (Object)new HandTpchQuery1(localQueryRunner), (Object[])new AbstractBenchmark[]{new HandTpchQuery6(localQueryRunner), new GroupBySumWithArithmeticSqlBenchmark(localQueryRunner), new CountAggregationSqlBenchmark(localQueryRunner), new SqlDoubleSumAggregationBenchmark(localQueryRunner), new CountWithFilterSqlBenchmark(localQueryRunner), new GroupByAggregationSqlBenchmark(localQueryRunner), new PredicateFilterSqlBenchmark(localQueryRunner), new RawStreamingSqlBenchmark(localQueryRunner), new Top100SqlBenchmark(localQueryRunner), new SqlHashJoinBenchmark(localQueryRunner), new SqlJoinWithPredicateBenchmark(localQueryRunner), new LongMaxAggregationSqlBenchmark(localQueryRunner), new VarBinaryMaxAggregationSqlBenchmark(localQueryRunner), new SqlDistinctMultipleFields(localQueryRunner), new SqlDistinctSingleField(localQueryRunner), new SqlTpchQuery1(localQueryRunner), new SqlTpchQuery6(localQueryRunner), new SqlLikeBenchmark(localQueryRunner), new SqlInBenchmark(localQueryRunner), new SqlSemiJoinInPredicateBenchmark(localQueryRunner), new SqlRegexpLikeBenchmark(localQueryRunner), new SqlApproximatePercentileBenchmark(localQueryRunner), new SqlBetweenBenchmark(localQueryRunner), new StatisticsBenchmark.LongVarianceBenchmark(localQueryRunner), new StatisticsBenchmark.LongVariancePopBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleVarianceBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleVariancePopBenchmark(localQueryRunner), new StatisticsBenchmark.LongStdDevBenchmark(localQueryRunner), new StatisticsBenchmark.LongStdDevPopBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleStdDevBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleStdDevPopBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayEqualsBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayLessThanBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayGreaterThanBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayNotEqualBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayLessThanOrEqualBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayGreaterThanOrEqualBenchmark(localQueryRunner), new SqlApproximateCountDistinctLongBenchmark(localQueryRunner), new SqlApproximateCountDistinctDoubleBenchmark(localQueryRunner), new SqlApproximateCountDistinctVarBinaryBenchmark(localQueryRunner)});
    }

    public BenchmarkSuite(LocalQueryRunner localQueryRunner, String outputDirectory) {
        this.localQueryRunner = localQueryRunner;
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "outputDirectory is null");
    }

    private static File createOutputFile(String fileName) throws IOException {
        File outputFile = new File(fileName);
        Files.createParentDirs((File)outputFile);
        return outputFile;
    }

    public void runAllBenchmarks() throws IOException {
        List<AbstractBenchmark> benchmarks = BenchmarkSuite.createBenchmarks(this.localQueryRunner);
        LOGGER.info("=== Pre-running all benchmarks for JVM warmup ===");
        for (AbstractBenchmark benchmark : benchmarks) {
            benchmark.runBenchmark();
        }
        LOGGER.info("=== Actually running benchmarks for metrics ===");
        for (AbstractBenchmark benchmark : benchmarks) {
            try (FileOutputStream jsonOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/json/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
                 FileOutputStream jsonAvgOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/json-avg/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
                 FileOutputStream csvOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/csv/%s.csv", this.outputDirectory, benchmark.getBenchmarkName())));
                 FileOutputStream odsOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/ods/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));){
                benchmark.runBenchmark(new ForwardingBenchmarkResultWriter((List<BenchmarkResultHook>)ImmutableList.of((Object)new JsonBenchmarkResultWriter(jsonOut), (Object)new JsonAvgBenchmarkResultWriter(jsonAvgOut), (Object)new SimpleLineBenchmarkResultWriter(csvOut), (Object)new OdsBenchmarkResultWriter("presto.benchmark." + benchmark.getBenchmarkName(), odsOut))));
            }
        }
    }

    private static class ForwardingBenchmarkResultWriter
    implements BenchmarkResultHook {
        private final List<BenchmarkResultHook> benchmarkResultHooks;

        private ForwardingBenchmarkResultWriter(List<BenchmarkResultHook> benchmarkResultHooks) {
            Objects.requireNonNull(benchmarkResultHooks, "benchmarkResultWriters is null");
            this.benchmarkResultHooks = ImmutableList.copyOf(benchmarkResultHooks);
        }

        @Override
        public BenchmarkResultHook addResults(Map<String, Long> results) {
            Objects.requireNonNull(results, "results is null");
            for (BenchmarkResultHook benchmarkResultHook : this.benchmarkResultHooks) {
                benchmarkResultHook.addResults(results);
            }
            return this;
        }

        @Override
        public void finished() {
            for (BenchmarkResultHook benchmarkResultHook : this.benchmarkResultHooks) {
                benchmarkResultHook.finished();
            }
        }
    }
}

