/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import io.prestosql.benchmark.AbstractSimpleOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.AggregationOperator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.LocalQueryRunner;
import java.util.List;
import java.util.Optional;

public class CountAggregationBenchmark
extends AbstractSimpleOperatorBenchmark {
    public CountAggregationBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "count_agg", 10, 100);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey");
        Metadata metadata = this.localQueryRunner.getMetadata();
        InternalAggregationFunction countFunction = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"count"), (List)ImmutableList.of()));
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)countFunction.bind((List)ImmutableList.of((Object)0), Optional.empty())), false);
        return ImmutableList.of((Object)tableScanOperator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new CountAggregationBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

