/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.prestosql.benchmark.AbstractSimpleOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.HashAggregationOperator;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.util.DateTimeUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HandTpchQuery1
extends AbstractSimpleOperatorBenchmark {
    private final InternalAggregationFunction longAverage;
    private final InternalAggregationFunction doubleAverage;
    private final InternalAggregationFunction doubleSum;
    private final InternalAggregationFunction countFunction;

    public HandTpchQuery1(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_1", 1, 5);
        Metadata metadata = localQueryRunner.getMetadata();
        this.longAverage = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"avg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        this.doubleAverage = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"avg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        this.doubleSum = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        this.countFunction = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"count"), (List)ImmutableList.of()));
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "returnflag", "linestatus", "quantity", "extendedprice", "discount", "tax", "shipdate");
        TpchQuery1Operator.TpchQuery1OperatorFactory tpchQuery1Operator = new TpchQuery1Operator.TpchQuery1OperatorFactory(1);
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(2, new PlanNodeId("test"), this.getColumnTypes("lineitem", "returnflag", "linestatus"), Ints.asList((int[])new int[]{0, 1}), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List)ImmutableList.of((Object)2), Optional.empty()), (Object)this.doubleSum.bind((List)ImmutableList.of((Object)3), Optional.empty()), (Object)this.doubleSum.bind((List)ImmutableList.of((Object)4), Optional.empty()), (Object)this.longAverage.bind((List)ImmutableList.of((Object)2), Optional.empty()), (Object)this.doubleAverage.bind((List)ImmutableList.of((Object)5), Optional.empty()), (Object)this.doubleAverage.bind((List)ImmutableList.of((Object)6), Optional.empty()), (Object)this.countFunction.bind((List)ImmutableList.of((Object)2), Optional.empty())), Optional.empty(), Optional.empty(), 10000, Optional.of(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), new JoinCompiler(this.localQueryRunner.getTypeOperators()), this.localQueryRunner.getBlockTypeOperators(), false);
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery1Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery1(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery1Operator
    implements Operator {
        private static final ImmutableList<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        private final OperatorContext operatorContext;
        private final PageBuilder pageBuilder;
        private boolean finishing;
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1998-09-02");

        public TpchQuery1Operator(OperatorContext operatorContext) {
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            this.pageBuilder = new PageBuilder(TYPES);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public void finish() {
            this.finishing = true;
        }

        public boolean isFinished() {
            return this.finishing && this.pageBuilder.isEmpty();
        }

        public boolean needsInput() {
            return !this.pageBuilder.isFull();
        }

        public void addInput(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Output buffer is full");
            Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finished");
            TpchQuery1Operator.filterAndProjectRowOriented(this.pageBuilder, page.getBlock(0), page.getBlock(1), page.getBlock(2), page.getBlock(3), page.getBlock(4), page.getBlock(5), page.getBlock(6));
        }

        public Page getOutput() {
            if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return page;
            }
            return null;
        }

        private static void filterAndProjectRowOriented(PageBuilder pageBuilder, Block returnFlagBlock, Block lineStatusBlock, Block quantityBlock, Block extendedPriceBlock, Block discountBlock, Block taxBlock, Block shipDateBlock) {
            int rows = returnFlagBlock.getPositionCount();
            for (int position = 0; position < rows; ++position) {
                int shipDate;
                if (shipDateBlock.isNull(position) || (shipDate = Math.toIntExact(DateType.DATE.getLong(shipDateBlock, position))) > MAX_SHIP_DATE) continue;
                pageBuilder.declarePosition();
                if (returnFlagBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(0).appendNull();
                } else {
                    VarcharType.VARCHAR.appendTo(returnFlagBlock, position, pageBuilder.getBlockBuilder(0));
                }
                if (lineStatusBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(1).appendNull();
                } else {
                    VarcharType.VARCHAR.appendTo(lineStatusBlock, position, pageBuilder.getBlockBuilder(1));
                }
                double quantity = DoubleType.DOUBLE.getDouble(quantityBlock, position);
                double extendedPrice = DoubleType.DOUBLE.getDouble(extendedPriceBlock, position);
                double discount = DoubleType.DOUBLE.getDouble(discountBlock, position);
                double tax = DoubleType.DOUBLE.getDouble(taxBlock, position);
                boolean quantityIsNull = quantityBlock.isNull(position);
                boolean extendedPriceIsNull = extendedPriceBlock.isNull(position);
                boolean discountIsNull = discountBlock.isNull(position);
                boolean taxIsNull = taxBlock.isNull(position);
                if (quantityIsNull) {
                    pageBuilder.getBlockBuilder(2).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(2), quantity);
                }
                if (extendedPriceIsNull) {
                    pageBuilder.getBlockBuilder(3).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), extendedPrice);
                }
                if (extendedPriceIsNull || discountIsNull) {
                    pageBuilder.getBlockBuilder(4).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), extendedPrice * (1.0 - discount));
                }
                if (extendedPriceIsNull || discountIsNull || taxIsNull) {
                    pageBuilder.getBlockBuilder(5).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(5), extendedPrice * (1.0 - discount) * (1.0 + tax));
                }
                if (discountIsNull) {
                    pageBuilder.getBlockBuilder(6).appendNull();
                    continue;
                }
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(6), discount);
            }
        }

        public static class TpchQuery1OperatorFactory
        implements OperatorFactory {
            private final int operatorId;

            public TpchQuery1OperatorFactory(int operatorId) {
                this.operatorId = operatorId;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, new PlanNodeId("test"), TpchQuery1Operator.class.getSimpleName());
                return new TpchQuery1Operator(operatorContext);
            }

            public void noMoreOperators() {
            }

            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

