/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.prestosql.benchmark.AbstractSimpleOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.HashAggregationOperator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.LocalQueryRunner;
import java.util.List;
import java.util.Optional;

public class HashAggregationBenchmark
extends AbstractSimpleOperatorBenchmark {
    private final InternalAggregationFunction doubleSum;

    public HashAggregationBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_agg", 5, 25);
        Metadata metadata = localQueryRunner.getMetadata();
        this.doubleSum = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        List<Type> tableTypes = this.getColumnTypes("orders", "orderstatus", "totalprice");
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderstatus", "totalprice");
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(1, new PlanNodeId("test"), (List)ImmutableList.of((Object)tableTypes.get(0)), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List)ImmutableList.of((Object)1), Optional.empty())), Optional.empty(), Optional.empty(), 100000, Optional.of(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), new JoinCompiler(this.localQueryRunner.getTypeOperators()), this.localQueryRunner.getBlockTypeOperators(), false);
        return ImmutableList.of((Object)tableScanOperator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HashAggregationBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

