/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.benchmark.AbstractOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.execution.Lifespan;
import io.prestosql.operator.Driver;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DriverFactory;
import io.prestosql.operator.HashBuilderOperator;
import io.prestosql.operator.JoinBridgeManager;
import io.prestosql.operator.LookupJoinOperators;
import io.prestosql.operator.LookupSourceProvider;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PagesIndex;
import io.prestosql.operator.PartitionedLookupSourceFactory;
import io.prestosql.operator.PipelineExecutionStrategy;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spiller.PartitioningSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.NullOutputOperator;
import io.prestosql.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;

public class HashJoinBenchmark
extends AbstractOperatorBenchmark {
    private static final LookupJoinOperators LOOKUP_JOIN_OPERATORS = new LookupJoinOperators();
    private DriverFactory probeDriverFactory;

    public HashJoinBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_join", 4, 50);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        if (this.probeDriverFactory == null) {
            List<Type> ordersTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
            OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
            BlockTypeOperators blockTypeOperators = new BlockTypeOperators(new TypeOperators());
            JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(ordersTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), 1, false, blockTypeOperators));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory());
            DriverContext driverContext = taskContext.addPipelineContext(0, false, false, false).addDriverContext();
            DriverFactory buildDriverFactory = new DriverFactory(0, false, false, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
            List<Type> lineItemTypes = this.getColumnTypes("lineitem", "orderkey", "quantity");
            OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");
            OperatorFactory joinOperator = LOOKUP_JOIN_OPERATORS.innerJoin(1, new PlanNodeId("test"), lookupSourceFactoryManager, lineItemTypes, Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), blockTypeOperators);
            NullOutputOperator.NullOutputOperatorFactory output = new NullOutputOperator.NullOutputOperatorFactory(2, new PlanNodeId("test"));
            this.probeDriverFactory = new DriverFactory(1, true, true, (List)ImmutableList.of((Object)lineItemTableScan, (Object)joinOperator, (Object)output), OptionalInt.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION);
            Driver driver = buildDriverFactory.createDriver(driverContext);
            ListenableFuture lookupSourceProvider = ((PartitionedLookupSourceFactory)lookupSourceFactoryManager.getJoinBridge(Lifespan.taskWide())).createLookupSourceProvider();
            while (!lookupSourceProvider.isDone()) {
                driver.process();
            }
            ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
        }
        DriverContext driverContext = taskContext.addPipelineContext(1, true, true, false).addDriverContext();
        Driver driver = this.probeDriverFactory.createDriver(driverContext);
        return ImmutableList.of((Object)driver);
    }

    public static void main(String[] args) {
        new HashJoinBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

