/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import io.airlift.stats.CpuTimer;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.benchmark.AbstractBenchmark;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.Split;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.Driver;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.FilterAndProjectOperator;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PageSourceOperator;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.TaskStats;
import io.prestosql.operator.project.InputPageProjection;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.split.SplitSource;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.HashGenerationOptimizer;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SqlToRowExpressionTranslator;
import io.prestosql.sql.tree.Expression;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TransactionId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOperatorBenchmark
extends AbstractBenchmark {
    protected final LocalQueryRunner localQueryRunner;
    protected final Session session;

    protected AbstractOperatorBenchmark(LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        this(localQueryRunner.getDefaultSession(), localQueryRunner, benchmarkName, warmupIterations, measuredIterations);
    }

    protected AbstractOperatorBenchmark(Session session, LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        super(benchmarkName, warmupIterations, measuredIterations);
        this.localQueryRunner = Objects.requireNonNull(localQueryRunner, "localQueryRunner is null");
        TransactionId transactionId = localQueryRunner.getTransactionManager().beginTransaction(false);
        this.session = session.beginTransactionId(transactionId, localQueryRunner.getTransactionManager(), (AccessControl)new AllowAllAccessControl());
    }

    @Override
    protected void tearDown() {
        this.localQueryRunner.getTransactionManager().asyncAbort(this.session.getRequiredTransactionId());
        super.tearDown();
    }

    protected final List<Type> getColumnTypes(String tableName, String ... columnNames) {
        Preconditions.checkState((boolean)this.session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkState((boolean)this.session.getSchema().isPresent(), (Object)"schema not set");
        Metadata metadata = this.localQueryRunner.getMetadata();
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName((String)this.session.getCatalog().get(), (String)this.session.getSchema().get(), tableName);
        TableHandle tableHandle = (TableHandle)metadata.getTableHandle(this.session, qualifiedTableName).orElseThrow(() -> new IllegalArgumentException(String.format("Table '%s' does not exist", qualifiedTableName)));
        Map allColumnHandles = metadata.getColumnHandles(this.session, tableHandle);
        return (List)Arrays.stream(columnNames).map(allColumnHandles::get).map(columnHandle -> metadata.getColumnMetadata(this.session, tableHandle, columnHandle).getType()).collect(ImmutableList.toImmutableList());
    }

    protected final OperatorFactory createTableScanOperator(final int operatorId, final PlanNodeId planNodeId, String tableName, String ... columnNames) {
        Preconditions.checkArgument((boolean)this.session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkArgument((boolean)this.session.getSchema().isPresent(), (Object)"schema not set");
        Metadata metadata = this.localQueryRunner.getMetadata();
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName((String)this.session.getCatalog().get(), (String)this.session.getSchema().get(), tableName);
        final TableHandle tableHandle = metadata.getTableHandle(this.session, qualifiedTableName).orElse(null);
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (String)"Table '%s' does not exist", (Object)qualifiedTableName);
        Map allColumnHandles = metadata.getColumnHandles(this.session, tableHandle);
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        for (String columnName : columnNames) {
            ColumnHandle columnHandle = (ColumnHandle)allColumnHandles.get(columnName);
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Table '%s' does not have a column '%s'", (Object)tableName, (Object)columnName);
            columnHandlesBuilder.add((Object)columnHandle);
        }
        ImmutableList columnHandles = columnHandlesBuilder.build();
        final Split split = this.getLocalQuerySplit(this.session, tableHandle);
        return new OperatorFactory((List)columnHandles){
            final /* synthetic */ List val$columnHandles;
            {
                this.val$columnHandles = list;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(operatorId, planNodeId, "BenchmarkSource");
                ConnectorPageSource pageSource = AbstractOperatorBenchmark.this.localQueryRunner.getPageSourceManager().createPageSource(AbstractOperatorBenchmark.this.session, split, tableHandle, this.val$columnHandles, DynamicFilter.EMPTY);
                return new PageSourceOperator(pageSource, operatorContext);
            }

            public void noMoreOperators() {
            }

            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Split getLocalQuerySplit(Session session, TableHandle handle) {
        SplitSource splitSource = this.localQueryRunner.getSplitManager().getSplits(session, handle, ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING, DynamicFilter.EMPTY);
        ArrayList<Split> splits = new ArrayList<Split>();
        while (!splitSource.isFinished()) {
            splits.addAll(AbstractOperatorBenchmark.getNextBatch(splitSource));
        }
        Preconditions.checkArgument((splits.size() == 1 ? 1 : 0) != 0, (String)"Expected only one split for a local query, but got %s splits", (int)splits.size());
        return (Split)splits.get(0);
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000))).getSplits();
    }

    protected final OperatorFactory createHashProjectOperator(int operatorId, PlanNodeId planNodeId, List<Type> types) {
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableMap.Builder symbolToInputMapping = ImmutableMap.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int channel = 0; channel < types.size(); ++channel) {
            Symbol symbol = symbolAllocator.newSymbol("h" + channel, types.get(channel));
            symbolToInputMapping.put((Object)symbol, (Object)channel);
            projections.add((Object)new InputPageProjection(channel, types.get(channel)));
        }
        Map symbolTypes = symbolAllocator.getTypes().allTypes();
        Optional hashExpression = HashGenerationOptimizer.getHashExpression((Metadata)this.localQueryRunner.getMetadata(), (SymbolAllocator)symbolAllocator, (List)ImmutableList.copyOf(symbolTypes.keySet()));
        Verify.verify((boolean)hashExpression.isPresent());
        Map expressionTypes = new TypeAnalyzer(this.localQueryRunner.getSqlParser(), this.localQueryRunner.getMetadata()).getTypes(this.session, TypeProvider.copyOf((Map)symbolTypes), (Expression)hashExpression.get());
        RowExpression translated = SqlToRowExpressionTranslator.translate((Expression)((Expression)hashExpression.get()), (Map)expressionTypes, (Map)symbolToInputMapping.build(), (Metadata)this.localQueryRunner.getMetadata(), (Session)this.session, (boolean)false);
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler(this.localQueryRunner.getMetadata(), 0);
        projections.add((Object)((PageProjection)functionCompiler.compileProjection(translated, Optional.empty()).get()));
        return FilterAndProjectOperator.createOperatorFactory((int)operatorId, (PlanNodeId)planNodeId, () -> new PageProcessor(Optional.empty(), (List)projections.build()), (List)ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))), (DataSize)SystemSessionProperties.getFilterAndProjectMinOutputPageSize((Session)this.session), (int)SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount((Session)this.session));
    }

    protected abstract List<Driver> createDrivers(TaskContext var1);

    protected Map<String, Long> execute(TaskContext taskContext) {
        List<Driver> drivers = this.createDrivers(taskContext);
        long peakMemory = 0L;
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.process();
                long lastPeakMemory = peakMemory;
                peakMemory = taskContext.getTaskStats().getUserMemoryReservation().toBytes();
                if (peakMemory <= lastPeakMemory) {
                    peakMemory = lastPeakMemory;
                }
                processed = true;
            }
            done = !processed;
        }
        return ImmutableMap.of((Object)"peak_memory", (Object)peakMemory);
    }

    @Override
    protected Map<String, Long> runOnce() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("optimizer.optimize-hash-generation", "true").setTransactionId(this.session.getRequiredTransactionId()).build();
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        TaskContext taskContext = new QueryContext(new QueryId("test"), DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.localQueryRunner.getExecutor(), this.localQueryRunner.getScheduler(), DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE), spillSpaceTracker).addTaskContext(new TaskStateMachine(new TaskId("query", 0, 0), (Executor)this.localQueryRunner.getExecutor()), session, () -> {}, false, false, OptionalInt.empty());
        CpuTimer cpuTimer = new CpuTimer();
        Map<String, Long> executionStats = this.execute(taskContext);
        CpuTimer.CpuDuration executionTime = cpuTimer.elapsedTime();
        TaskStats taskStats = taskContext.getTaskStats();
        long inputRows = taskStats.getRawInputPositions();
        long inputBytes = taskStats.getRawInputDataSize().toBytes();
        long outputRows = taskStats.getOutputPositions();
        long outputBytes = taskStats.getOutputDataSize().toBytes();
        double inputMegaBytes = (double)inputBytes / (double)DataSize.Unit.MEGABYTE.inBytes();
        return ImmutableMap.builder().putAll(executionStats).put((Object)"elapsed_millis", (Object)executionTime.getWall().toMillis()).put((Object)"input_rows_per_second", (Object)((long)((double)inputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"output_rows_per_second", (Object)((long)((double)outputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"input_megabytes", (Object)((long)inputMegaBytes)).put((Object)"input_megabytes_per_second", (Object)((long)(inputMegaBytes / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"wall_nanos", (Object)executionTime.getWall().roundTo(TimeUnit.NANOSECONDS)).put((Object)"cpu_nanos", (Object)executionTime.getCpu().roundTo(TimeUnit.NANOSECONDS)).put((Object)"user_nanos", (Object)executionTime.getUser().roundTo(TimeUnit.NANOSECONDS)).put((Object)"input_rows", (Object)inputRows).put((Object)"input_bytes", (Object)inputBytes).put((Object)"output_rows", (Object)outputRows).put((Object)"output_bytes", (Object)outputBytes).build();
    }
}

