/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.benchmark;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.benchmark.AbstractSimpleOperatorBenchmark;
import io.prestosql.benchmark.BenchmarkQueryRunner;
import io.prestosql.benchmark.SimpleLineBenchmarkResultWriter;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.AggregationOperator;
import io.prestosql.operator.FilterAndProjectOperator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.project.InputChannels;
import io.prestosql.operator.project.PageFilter;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.util.DateTimeUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class HandTpchQuery6
extends AbstractSimpleOperatorBenchmark {
    private final InternalAggregationFunction doubleSum;

    public HandTpchQuery6(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_6", 10, 100);
        Metadata metadata = localQueryRunner.getMetadata();
        this.doubleSum = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"sum"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "extendedprice", "discount", "shipdate", "quantity");
        Supplier projection = new PageFunctionCompiler(this.localQueryRunner.getMetadata(), 0).compileProjection((RowExpression)Expressions.field((int)0, (Type)BigintType.BIGINT), Optional.empty());
        OperatorFactory tpchQuery6Operator = FilterAndProjectOperator.createOperatorFactory((int)1, (PlanNodeId)new PlanNodeId("test"), () -> HandTpchQuery6.lambda$createOperatorFactories$0((Supplier)projection), (List)ImmutableList.of((Object)DoubleType.DOUBLE), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(2, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List)ImmutableList.of((Object)0), Optional.empty())), false);
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery6Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery6(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    private static /* synthetic */ PageProcessor lambda$createOperatorFactories$0(Supplier projection) {
        return new PageProcessor(Optional.of(new TpchQuery6Filter()), (List)ImmutableList.of((Object)((PageProjection)projection.get())));
    }

    public static class TpchQuery6Filter
    implements PageFilter {
        private static final int MIN_SHIP_DATE = DateTimeUtils.parseDate((String)"1994-01-01");
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1995-01-01");
        private static final InputChannels INPUT_CHANNELS = new InputChannels(new int[]{1, 2, 3});
        private boolean[] selectedPositions = new boolean[0];

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return INPUT_CHANNELS;
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            if (this.selectedPositions.length < page.getPositionCount()) {
                this.selectedPositions = new boolean[page.getPositionCount()];
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.selectedPositions[position] = TpchQuery6Filter.filter(page, position);
            }
            return PageFilter.positionsArrayToSelectedPositions((boolean[])this.selectedPositions, (int)page.getPositionCount());
        }

        private static boolean filter(Page page, int position) {
            Block discountBlock = page.getBlock(0);
            Block shipDateBlock = page.getBlock(1);
            Block quantityBlock = page.getBlock(2);
            return !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) >= (long)MIN_SHIP_DATE && !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) < (long)MAX_SHIP_DATE && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && BigintType.BIGINT.getLong(quantityBlock, position) < 24L;
        }
    }
}

