/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.auth.oauth2.GoogleCredentials;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.prestosql.plugin.bigquery.ReadSessionCreatorConfig;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalInt;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;

public class BigQueryConfig {
    public static final int DEFAULT_MAX_READ_ROWS_RETRIES = 3;
    public static final String VIEWS_ENABLED = "bigquery.views-enabled";
    private Optional<String> credentialsKey = Optional.empty();
    private Optional<String> credentialsFile = Optional.empty();
    private Optional<String> projectId = Optional.empty();
    private Optional<String> parentProjectId = Optional.empty();
    private OptionalInt parallelism = OptionalInt.empty();
    private boolean viewsEnabled;
    private Optional<String> viewMaterializationProject = Optional.empty();
    private Optional<String> viewMaterializationDataset = Optional.empty();
    private int maxReadRowsRetries = 3;

    @AssertTrue(message="Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified, or the default GoogleCredentials could be created")
    public @AssertTrue(message="Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified, or the default GoogleCredentials could be created") boolean isCredentialsConfigurationValid() {
        if (this.credentialsKey.isPresent() && this.credentialsFile.isPresent()) {
            return false;
        }
        if (this.credentialsKey.isEmpty() && this.credentialsFile.isEmpty()) {
            try {
                GoogleCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public Optional<String> getCredentialsKey() {
        return this.credentialsKey;
    }

    @Config(value="bigquery.credentials-key")
    @ConfigDescription(value="The base64 encoded credentials key")
    public BigQueryConfig setCredentialsKey(String credentialsKey) {
        this.credentialsKey = Optional.of(credentialsKey);
        return this;
    }

    public Optional<String> getCredentialsFile() {
        return this.credentialsFile;
    }

    @Config(value="bigquery.credentials-file")
    @ConfigDescription(value="The path to the JSON credentials file")
    public BigQueryConfig setCredentialsFile(String credentialsFile) {
        this.credentialsFile = Optional.of(credentialsFile);
        return this;
    }

    public Optional<String> getProjectId() {
        return this.projectId;
    }

    @Config(value="bigquery.project-id")
    @ConfigDescription(value="The Google Cloud Project ID where the data reside")
    public BigQueryConfig setProjectId(String projectId) {
        this.projectId = Optional.of(projectId);
        return this;
    }

    public Optional<String> getParentProjectId() {
        return this.parentProjectId;
    }

    @Config(value="bigquery.parent-project-id")
    @ConfigDescription(value="The Google Cloud Project ID to bill for the export")
    public BigQueryConfig setParentProjectId(String parentProjectId) {
        this.parentProjectId = Optional.of(parentProjectId);
        return this;
    }

    public OptionalInt getParallelism() {
        return this.parallelism;
    }

    @Config(value="bigquery.parallelism")
    @ConfigDescription(value="The number of partitions to split the data into.")
    public BigQueryConfig setParallelism(int parallelism) {
        this.parallelism = OptionalInt.of(parallelism);
        return this;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Config(value="bigquery.views-enabled")
    @ConfigDescription(value="Enables the connector to read from views and not only tables")
    public BigQueryConfig setViewsEnabled(boolean viewsEnabled) {
        this.viewsEnabled = viewsEnabled;
        return this;
    }

    public int getViewExpirationTimeInHours() {
        return 24;
    }

    public Optional<String> getViewMaterializationProject() {
        return this.viewMaterializationProject;
    }

    @Config(value="bigquery.view-materialization-project")
    @ConfigDescription(value="The project where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationProject(String viewMaterializationProject) {
        this.viewMaterializationProject = Optional.of(viewMaterializationProject);
        return this;
    }

    public Optional<String> getViewMaterializationDataset() {
        return this.viewMaterializationDataset;
    }

    @Config(value="bigquery.view-materialization-dataset")
    @ConfigDescription(value="The dataset where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationDataset(String viewMaterializationDataset) {
        this.viewMaterializationDataset = Optional.of(viewMaterializationDataset);
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    @Config(value="bigquery.max-read-rows-retries")
    @ConfigDescription(value="The number of retries in case of retryable server issues")
    public BigQueryConfig setMaxReadRowsRetries(int maxReadRowsRetries) {
        this.maxReadRowsRetries = maxReadRowsRetries;
        return this;
    }

    ReadSessionCreatorConfig createReadSessionCreatorConfig() {
        return new ReadSessionCreatorConfig(this.isViewsEnabled(), this.getViewMaterializationProject(), this.getViewMaterializationProject(), this.getViewExpirationTimeInHours(), this.getMaxReadRowsRetries());
    }
}

