/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.prestosql.plugin.bigquery.BigQueryClient;
import io.prestosql.plugin.bigquery.BigQueryColumnHandle;
import io.prestosql.plugin.bigquery.BigQueryConfig;
import io.prestosql.plugin.bigquery.BigQueryTableHandle;
import io.prestosql.plugin.bigquery.Conversions;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.NotFoundException;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class BigQueryMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(BigQueryMetadata.class);
    static final int NUMERIC_DATA_TYPE_PRECISION = 38;
    static final int NUMERIC_DATA_TYPE_SCALE = 9;
    static final String INFORMATION_SCHEMA = "information_schema";
    private final BigQueryClient bigQueryClient;
    private final String projectId;

    @Inject
    public BigQueryMetadata(BigQueryClient bigQueryClient, BigQueryConfig config) {
        this.bigQueryClient = Objects.requireNonNull(bigQueryClient, "bigQueryClient is null");
        this.projectId = Objects.requireNonNull(config, "config is null").getProjectId().orElse(bigQueryClient.getProjectId());
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        log.debug("listSchemaNames(session=%s)", new Object[]{session});
        return (List)Streams.stream(this.bigQueryClient.listDatasets(this.projectId)).map(dataset -> dataset.getDatasetId().getDataset()).filter(schemaName -> !schemaName.equalsIgnoreCase(INFORMATION_SCHEMA)).collect(ImmutableList.toImmutableList());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        log.debug("listTables(session=%s, schemaName=%s)", new Object[]{session, schemaName});
        return this.listTablesWithTypes(session, schemaName, TableDefinition.Type.TABLE);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        log.debug("listViews(session=%s, schemaName=%s)", new Object[]{session, schemaName});
        return this.listTablesWithTypes(session, schemaName, TableDefinition.Type.VIEW);
    }

    private List<SchemaTableName> listTablesWithTypes(ConnectorSession session, Optional<String> schemaName, TableDefinition.Type ... types) {
        if (schemaName.isPresent() && schemaName.get().equalsIgnoreCase(INFORMATION_SCHEMA)) {
            return ImmutableList.of();
        }
        Set schemaNames = (Set)schemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.listSchemaNames(session)));
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String datasetId : schemaNames) {
            for (Table table : this.bigQueryClient.listTables(DatasetId.of((String)this.projectId, (String)datasetId), types)) {
                tableNames.add((Object)new SchemaTableName(datasetId, table.getTableId().getTable()));
            }
        }
        return tableNames.build();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        log.debug("getTableHandle(session=%s, tableName=%s)", new Object[]{session, tableName});
        TableInfo tableInfo = this.getBigQueryTable(tableName);
        if (tableInfo == null) {
            log.debug("Table [%s.%s] was not found", new Object[]{tableName.getSchemaName(), tableName.getTableName()});
            return null;
        }
        return BigQueryTableHandle.from(tableInfo);
    }

    private TableInfo getBigQueryTable(SchemaTableName tableName) {
        return this.bigQueryClient.getTable(TableId.of((String)this.projectId, (String)tableName.getSchemaName(), (String)tableName.getTableName()));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName schemaTableName) {
        ConnectorTableHandle table = this.getTableHandle(session, schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return this.getTableMetadata(session, table);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        log.debug("getTableMetadata(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        TableInfo table = this.bigQueryClient.getTable(((BigQueryTableHandle)tableHandle).getTableId());
        SchemaTableName schemaTableName = new SchemaTableName(table.getTableId().getDataset(), table.getTableId().getTable());
        Schema schema = table.getDefinition().getSchema();
        ImmutableList columns = schema == null ? ImmutableList.of() : (List)schema.getFields().stream().map(Conversions::toColumnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(schemaTableName, (List)columns);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        log.debug("getColumnHandles(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        List<BigQueryColumnHandle> columnHandles = this.getTableColumns(((BigQueryTableHandle)tableHandle).getTableId());
        return columnHandles.stream().collect(Collectors.toMap(BigQueryColumnHandle::getName, Function.identity()));
    }

    List<BigQueryColumnHandle> getTableColumns(TableId tableId) {
        return this.getTableColumns(this.bigQueryClient.getTable(tableId));
    }

    private List<BigQueryColumnHandle> getTableColumns(TableInfo table) {
        ImmutableList.Builder columns = ImmutableList.builder();
        TableDefinition tableDefinition = table.getDefinition();
        Schema schema = tableDefinition.getSchema();
        if (schema != null) {
            for (Field field : schema.getFields()) {
                columns.add((Object)Conversions.toColumnHandle(field));
            }
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        log.debug("getColumnMetadata(session=%s, tableHandle=%s, columnHandle=%s)", new Object[]{session, columnHandle, columnHandle});
        return ((BigQueryColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        log.debug("listTableColumns(session=%s, prefix=%s)", new Object[]{session, prefix});
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (NotFoundException notFoundException) {}
        }
        return columns.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        TableInfo tableInfo = this.getBigQueryTable(tableName);
        return tableInfo == null ? ImmutableList.of() : ImmutableList.of((Object)tableName);
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        log.debug("getTableProperties(session=%s, prefix=%s)", new Object[]{session, table});
        return new ConnectorTableProperties();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        log.debug("applyLimit(session=%s, handle=%s, limit=%s)", new Object[]{session, handle, limit});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        if (bigQueryTableHandle.getLimit().isPresent() && bigQueryTableHandle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        bigQueryTableHandle = bigQueryTableHandle.withLimit(limit);
        return Optional.of(new LimitApplicationResult((Object)bigQueryTableHandle, false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        log.debug("applyProjection(session=%s, handle=%s, projections=%s, assignments=%s)", new Object[]{session, handle, projections, assignments});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        if (bigQueryTableHandle.getProjectedColumns().isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder assignmentList = ImmutableList.builder();
        assignments.forEach((name, column) -> {
            projectedColumns.add(column);
            assignmentList.add((Object)new ProjectionApplicationResult.Assignment(name, column, ((BigQueryColumnHandle)column).getPrestoType()));
        });
        bigQueryTableHandle = bigQueryTableHandle.withProjectedColumns((List<ColumnHandle>)projectedColumns.build());
        return Optional.of(new ProjectionApplicationResult((Object)bigQueryTableHandle, projections, (List)assignmentList.build()));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        log.debug("applyFilter(session=%s, handle=%s, summary=%s, predicate=%s, columns=%s)", new Object[]{session, handle, constraint.getSummary(), constraint.predicate(), constraint.getPredicateColumns()});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        TupleDomain<ColumnHandle> oldDomain = bigQueryTableHandle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        BigQueryTableHandle updatedHandle = bigQueryTableHandle.withConstraint((TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)updatedHandle, constraint.getSummary()));
    }
}

