/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.plugin.bigquery.BigQueryClient;
import io.prestosql.plugin.bigquery.BigQueryColumnHandle;
import io.prestosql.plugin.bigquery.BigQueryConfig;
import io.prestosql.plugin.bigquery.BigQueryErrorCode;
import io.prestosql.plugin.bigquery.BigQueryFilterQueryBuilder;
import io.prestosql.plugin.bigquery.BigQuerySplit;
import io.prestosql.plugin.bigquery.BigQueryStorageClientFactory;
import io.prestosql.plugin.bigquery.BigQueryTableHandle;
import io.prestosql.plugin.bigquery.ReadSessionCreator;
import io.prestosql.plugin.bigquery.ReadSessionCreatorConfig;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class BigQuerySplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(BigQuerySplitManager.class);
    private final BigQueryClient bigQueryClient;
    private final BigQueryStorageClientFactory bigQueryStorageClientFactory;
    private final OptionalInt parallelism;
    private final ReadSessionCreatorConfig readSessionCreatorConfig;
    private final NodeManager nodeManager;

    @Inject
    public BigQuerySplitManager(BigQueryConfig config, BigQueryClient bigQueryClient, BigQueryStorageClientFactory bigQueryStorageClientFactory, NodeManager nodeManager) {
        Objects.requireNonNull(config, "config cannot be null");
        this.bigQueryClient = Objects.requireNonNull(bigQueryClient, "bigQueryClient cannot be null");
        this.bigQueryStorageClientFactory = Objects.requireNonNull(bigQueryStorageClientFactory, "bigQueryStorageClientFactory cannot be null");
        this.parallelism = config.getParallelism();
        this.readSessionCreatorConfig = config.createReadSessionCreatorConfig();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager cannot be null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        log.debug("getSplits(transaction=%s, session=%s, table=%s, splitSchedulingStrategy=%s)", new Object[]{transaction, session, table, splitSchedulingStrategy});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)table;
        TableId tableId = bigQueryTableHandle.getTableId();
        int actualParallelism = this.parallelism.orElse(this.nodeManager.getRequiredWorkerNodes().size());
        TupleDomain<ColumnHandle> constraint = bigQueryTableHandle.getConstraint();
        Optional<String> filter = BigQueryFilterQueryBuilder.buildFilter(constraint);
        List<BigQuerySplit> splits = BigQuerySplitManager.emptyProjectionIsRequired(bigQueryTableHandle.getProjectedColumns()) ? this.createEmptyProjection(tableId, actualParallelism, filter) : this.readFromBigQuery(tableId, bigQueryTableHandle.getProjectedColumns(), actualParallelism, filter);
        return new FixedSplitSource(splits);
    }

    private static boolean emptyProjectionIsRequired(Optional<List<ColumnHandle>> projectedColumns) {
        return projectedColumns.isPresent() && projectedColumns.get().isEmpty();
    }

    private List<BigQuerySplit> readFromBigQuery(TableId tableId, Optional<List<ColumnHandle>> projectedColumns, int actualParallelism, Optional<String> filter) {
        log.debug("readFromBigQuery(tableId=%s, projectedColumns=%s, actualParallelism=%s, filter=[%s])", new Object[]{tableId, projectedColumns, actualParallelism, filter});
        List<ColumnHandle> columns = projectedColumns.orElse((List<ColumnHandle>)ImmutableList.of());
        List projectedColumnsNames = (List)columns.stream().map(column -> ((BigQueryColumnHandle)column).getName()).collect(ImmutableList.toImmutableList());
        Storage.ReadSession readSession = new ReadSessionCreator(this.readSessionCreatorConfig, this.bigQueryClient, this.bigQueryStorageClientFactory).create(tableId, projectedColumnsNames, filter, actualParallelism);
        return (List)readSession.getStreamsList().stream().map(stream -> BigQuerySplit.forStream(stream.getName(), readSession.getAvroSchema().getSchema(), columns)).collect(ImmutableList.toImmutableList());
    }

    private List<BigQuerySplit> createEmptyProjection(TableId tableId, int actualParallelism, Optional<String> filter) {
        log.debug("createEmptyProjection(tableId=%s, actualParallelism=%s, filter=[%s])", new Object[]{tableId, actualParallelism, filter});
        try {
            long numberOfRows;
            if (filter.isPresent()) {
                String sql = this.bigQueryClient.selectSql(tableId, "COUNT(*)", new String[]{filter.get()});
                TableResult result = this.bigQueryClient.query(sql);
                numberOfRows = ((FieldValueList)result.iterateAll().iterator().next()).get(0).getLongValue();
            } else {
                numberOfRows = this.bigQueryClient.getTable(tableId).getNumRows().longValue();
            }
            long rowsPerSplit = numberOfRows / (long)actualParallelism;
            long remainingRows = numberOfRows - rowsPerSplit * (long)actualParallelism;
            List<BigQuerySplit> splits = IntStream.range(0, actualParallelism).mapToObj(ignored -> BigQuerySplit.emptyProjection(rowsPerSplit)).collect(Collectors.toList());
            splits.set(0, BigQuerySplit.emptyProjection(rowsPerSplit + remainingRows));
            return splits;
        }
        catch (BigQueryException e) {
            throw new PrestoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_FAILED_TO_EXECUTE_QUERY, "Failed to compute empty projection", (Throwable)e);
        }
    }
}

