/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum BigQueryType {
    BOOLEAN((Type)BooleanType.BOOLEAN, BigQueryType::simpleToStringConverter),
    BYTES((Type)VarbinaryType.VARBINARY, BigQueryType::bytesToStringConverter),
    DATE((Type)DateType.DATE, BigQueryType::dateToStringConverter),
    DATETIME((Type)TimestampType.TIMESTAMP, BigQueryType::datetimeToStringConverter),
    FLOAT((Type)DoubleType.DOUBLE, BigQueryType::simpleToStringConverter),
    GEOGRAPHY((Type)VarcharType.VARCHAR, BigQueryType::stringToStringConverter),
    INTEGER((Type)BigintType.BIGINT, BigQueryType::simpleToStringConverter),
    NUMERIC((Type)DecimalType.createDecimalType((int)38, (int)9), BigQueryType::numericToStringConverter),
    RECORD(null, BigQueryType::simpleToStringConverter),
    STRING((Type)VarcharType.createUnboundedVarcharType(), BigQueryType::stringToStringConverter),
    TIME((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, BigQueryType::timeToStringConverter),
    TIMESTAMP((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, BigQueryType::timestampToStringConverter);

    private static final int[] NANO_FACTOR;
    private static final DateTimeFormatter DATETIME_FORMATTER;
    private final Type nativeType;
    private final ToStringConverter toStringConverter;

    private BigQueryType(Type nativeType, ToStringConverter toStringConverter) {
        this.nativeType = nativeType;
        this.toStringConverter = toStringConverter;
    }

    static RowType.Field toRawTypeField(Map.Entry<String, Adaptor> entry) {
        return BigQueryType.toRawTypeField(entry.getKey(), entry.getValue());
    }

    static RowType.Field toRawTypeField(String name, Adaptor typeAdaptor) {
        Type prestoType = typeAdaptor.getPrestoType();
        return RowType.field((String)name, (Type)prestoType);
    }

    static LocalDateTime toLocalDateTime(String datetime) {
        int dotPosition = datetime.indexOf(46);
        if (dotPosition == -1) {
            return LocalDateTime.from(DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(datetime));
        }
        LocalDateTime result = LocalDateTime.from(DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(datetime.substring(0, dotPosition)));
        String nanosStr = datetime.substring(dotPosition + 1);
        int nanoOfSecond = Integer.parseInt(nanosStr) * NANO_FACTOR[nanosStr.length()];
        return result.withNano(nanoOfSecond);
    }

    static long toPrestoTimestamp(String datetime) {
        return BigQueryType.toLocalDateTime(datetime).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
    }

    static String simpleToStringConverter(Object value) {
        return String.valueOf(value);
    }

    static String dateToStringConverter(Object value) {
        LocalDate date = LocalDate.ofEpochDay((Long)value);
        return BigQueryType.quote(date.toString());
    }

    static String datetimeToStringConverter(Object value) {
        return BigQueryType.formatTimestamp((Long)value, ZoneOffset.systemDefault());
    }

    static String timeToStringConverter(Object value) {
        long longValue = (Long)value;
        long millisUtc = DateTimeEncoding.unpackMillisUtc((long)longValue);
        ZoneId zoneId = ZoneId.of(DateTimeEncoding.unpackZoneKey((long)longValue).getId());
        LocalTime time = BigQueryType.toZonedDateTime(millisUtc, zoneId).toLocalTime();
        return BigQueryType.quote(time.toString());
    }

    static String timestampToStringConverter(Object value) {
        long longValue = (Long)value;
        long millisUtc = DateTimeEncoding.unpackMillisUtc((long)longValue);
        ZoneId zoneId = ZoneId.of(DateTimeEncoding.unpackZoneKey((long)longValue).getId());
        return BigQueryType.formatTimestamp(millisUtc, zoneId);
    }

    private static String formatTimestamp(long millisUtc, ZoneId zoneId) {
        return DATETIME_FORMATTER.format(BigQueryType.toZonedDateTime(millisUtc, zoneId));
    }

    private static ZonedDateTime toZonedDateTime(long millisUtc, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millisUtc), zoneId);
    }

    static String stringToStringConverter(Object value) {
        Slice slice = (Slice)value;
        return BigQueryType.quote(slice.toStringUtf8());
    }

    static String numericToStringConverter(Object value) {
        Slice slice = (Slice)value;
        return Decimals.toString((Slice)slice, (int)9);
    }

    static String bytesToStringConverter(Object value) {
        Slice slice = (Slice)value;
        return String.format("FROM_BASE64('%s')", Base64.getEncoder().encodeToString(slice.getBytes()));
    }

    private static String quote(String value) {
        return "'" + value + "'";
    }

    String convertToString(Object value) {
        return this.toStringConverter.convertToString(value);
    }

    public Type getNativeType(Adaptor typeAdaptor) {
        switch (this) {
            case RECORD: {
                Map<String, Adaptor> subTypes = typeAdaptor.getBigQuerySubTypes();
                Preconditions.checkArgument((!subTypes.isEmpty() ? 1 : 0) != 0, (Object)"a record or struct must have sub-fields");
                List fields = subTypes.entrySet().stream().map(BigQueryType::toRawTypeField).collect(Collectors.toList());
                return RowType.from(fields);
            }
        }
        return this.nativeType;
    }

    static {
        NANO_FACTOR = new int[]{-1, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
        DATETIME_FORMATTER = DateTimeFormatter.ofPattern("''yyyy-MM-dd HH:mm:ss.SSS''");
    }

    @FunctionalInterface
    static interface ToStringConverter {
        public String convertToString(Object var1);
    }

    static interface Adaptor {
        public BigQueryType getBigQueryType();

        public Map<String, Adaptor> getBigQuerySubTypes();

        public Field.Mode getMode();

        default public Type getPrestoType() {
            Type rawType = this.getBigQueryType().getNativeType(this);
            return this.getMode() == Field.Mode.REPEATED ? new ArrayType(rawType) : rawType;
        }
    }
}

