/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import io.prestosql.plugin.bigquery.BigQueryUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ReadRowsHelper {
    private final BigQueryStorageClient client;
    private final Storage.ReadRowsRequest.Builder request;
    private final int maxReadRowsRetries;

    public ReadRowsHelper(BigQueryStorageClient client, Storage.ReadRowsRequest.Builder request, int maxReadRowsRetries) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.request = Objects.requireNonNull(request, "request cannot be null");
        this.maxReadRowsRetries = maxReadRowsRetries;
    }

    public Iterator<Storage.ReadRowsResponse> readRows() {
        Iterator<Storage.ReadRowsResponse> serverResponses = this.fetchResponses(this.request);
        return new ReadRowsIterator(this, this.request.getReadPositionBuilder(), serverResponses);
    }

    protected Iterator<Storage.ReadRowsResponse> fetchResponses(Storage.ReadRowsRequest.Builder readRowsRequest) {
        return this.client.readRowsCallable().call((Object)readRowsRequest.build()).iterator();
    }

    private static class ReadRowsIterator
    implements Iterator<Storage.ReadRowsResponse> {
        private final ReadRowsHelper helper;
        private final Storage.StreamPosition.Builder readPosition;
        private Iterator<Storage.ReadRowsResponse> serverResponses;
        private long readRowsCount;
        private int retries;

        public ReadRowsIterator(ReadRowsHelper helper, Storage.StreamPosition.Builder readPosition, Iterator<Storage.ReadRowsResponse> serverResponses) {
            this.helper = helper;
            this.readPosition = readPosition;
            this.serverResponses = serverResponses;
        }

        @Override
        public boolean hasNext() {
            return this.serverResponses.hasNext();
        }

        @Override
        public Storage.ReadRowsResponse next() {
            while (true) {
                try {
                    Storage.ReadRowsResponse response = this.serverResponses.next();
                    this.readRowsCount += response.getRowCount();
                    return response;
                }
                catch (Exception e) {
                    if (BigQueryUtil.isRetryable(e) && this.retries < this.helper.maxReadRowsRetries) {
                        this.serverResponses = this.helper.fetchResponses(this.helper.request.setReadPosition(this.readPosition.setOffset(this.readRowsCount)));
                        ++this.retries;
                        continue;
                    }
                    this.helper.client.close();
                    throw e;
                    if (this.serverResponses.hasNext()) continue;
                    throw new NoSuchElementException("No more server responses");
                }
                break;
            }
        }
    }
}

