/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.airlift.log.Logger;
import io.prestosql.plugin.bigquery.BigQueryClient;
import io.prestosql.plugin.bigquery.BigQueryErrorCode;
import io.prestosql.plugin.bigquery.BigQueryStorageClientFactory;
import io.prestosql.plugin.bigquery.BigQueryUtil;
import io.prestosql.plugin.bigquery.ReadSessionCreatorConfig;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ReadSessionCreator {
    private static final Logger log = Logger.get(ReadSessionCreator.class);
    private static final Cache<String, TableInfo> destinationTableCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private final ReadSessionCreatorConfig config;
    private final BigQueryClient bigQueryClient;
    private final BigQueryStorageClientFactory bigQueryStorageClientFactory;

    public ReadSessionCreator(ReadSessionCreatorConfig config, BigQueryClient bigQueryClient, BigQueryStorageClientFactory bigQueryStorageClientFactory) {
        this.config = config;
        this.bigQueryClient = bigQueryClient;
        this.bigQueryStorageClientFactory = bigQueryStorageClientFactory;
    }

    public Storage.ReadSession create(TableId table, List<String> selectedFields, Optional<String> filter, int parallelism) {
        TableInfo tableDetails = this.bigQueryClient.getTable(table);
        TableInfo actualTable = this.getActualTable(tableDetails, selectedFields);
        List filteredSelectedFields = selectedFields.stream().filter(BigQueryUtil::validColumnName).collect(Collectors.toList());
        try (BigQueryStorageClient bigQueryStorageClient = this.bigQueryStorageClientFactory.createBigQueryStorageClient();){
            Storage.ReadSession readSession;
            ReadOptions.TableReadOptions.Builder readOptions = ReadOptions.TableReadOptions.newBuilder().addAllSelectedFields(filteredSelectedFields);
            filter.ifPresent(arg_0 -> ((ReadOptions.TableReadOptions.Builder)readOptions).setRowRestriction(arg_0));
            TableReferenceProto.TableReference tableReference = this.toTableReference(actualTable.getTableId());
            Storage.ReadSession readSession2 = readSession = bigQueryStorageClient.createReadSession(Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + this.bigQueryClient.getProjectId()).setFormat(Storage.DataFormat.AVRO).setRequestedStreams(parallelism).setReadOptions(readOptions).setTableReference(tableReference).setShardingStrategy(Storage.ShardingStrategy.BALANCED).build());
            return readSession2;
        }
    }

    TableReferenceProto.TableReference toTableReference(TableId tableId) {
        return TableReferenceProto.TableReference.newBuilder().setProjectId(tableId.getProject()).setDatasetId(tableId.getDataset()).setTableId(tableId.getTable()).build();
    }

    private TableInfo getActualTable(TableInfo table, List<String> requiredColumns) {
        TableDefinition tableDefinition = table.getDefinition();
        TableDefinition.Type tableType = tableDefinition.getType();
        if (TableDefinition.Type.TABLE == tableType) {
            return table;
        }
        if (TableDefinition.Type.VIEW == tableType) {
            if (!this.config.viewsEnabled) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Views are not enabled. You can enable views by setting '%s' to true. Notice additional cost may occur.", "bigquery.views-enabled"));
            }
            String query = this.bigQueryClient.selectSql(table.getTableId(), requiredColumns);
            log.debug("query is %s", new Object[]{query});
            try {
                return (TableInfo)destinationTableCache.get((Object)query, (Callable)new DestinationTableBuilder(this.bigQueryClient, this.config, query, table.getTableId()));
            }
            catch (ExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_VIEW_DESTINATION_TABLE_CREATION_FAILED, "Error creating destination table", (Throwable)e);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table type '%s' of table '%s.%s' is not supported", tableType, table.getTableId().getDataset(), table.getTableId().getTable()));
    }

    private static class DestinationTableBuilder
    implements Callable<TableInfo> {
        private final BigQueryClient bigQueryClient;
        private final ReadSessionCreatorConfig config;
        private final String query;
        private final TableId table;

        DestinationTableBuilder(BigQueryClient bigQueryClient, ReadSessionCreatorConfig config, String query, TableId table) {
            this.bigQueryClient = Objects.requireNonNull(bigQueryClient, "bigQueryClient is null");
            this.config = Objects.requireNonNull(config, "config is null");
            this.query = Objects.requireNonNull(query, "query is null");
            this.table = Objects.requireNonNull(table, "table is null");
        }

        @Override
        public TableInfo call() {
            return this.createTableFromQuery();
        }

        TableInfo createTableFromQuery() {
            TableId destinationTable = this.bigQueryClient.createDestinationTable(this.table);
            log.debug("destinationTable is %s", new Object[]{destinationTable});
            JobInfo jobInfo = JobInfo.of((JobConfiguration)QueryJobConfiguration.newBuilder((String)this.query).setDestinationTable(destinationTable).build());
            log.debug("running query %s", new Object[]{jobInfo});
            Job job = this.waitForJob(this.bigQueryClient.create(jobInfo));
            log.debug("job has finished. %s", new Object[]{job});
            if (job.getStatus().getError() != null) {
                throw BigQueryUtil.convertToBigQueryException(job.getStatus().getError());
            }
            TableInfo createdTable = this.bigQueryClient.getTable(destinationTable);
            long expirationTime = createdTable.getCreationTime() + TimeUnit.HOURS.toMillis(this.config.viewExpirationTimeInHours);
            Table updatedTable = this.bigQueryClient.update(createdTable.toBuilder().setExpirationTime(Long.valueOf(expirationTime)).build());
            return updatedTable;
        }

        Job waitForJob(Job job) {
            try {
                return job.waitFor(new RetryOption[0]);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BigQueryException(0, String.format("Job %s has been interrupted", job.getJobId()), (Throwable)e);
            }
        }
    }
}

