/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jodabridge;

import java.time.Instant;
import java.time.ZoneId;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class JdkBasedDateTimeZone
extends DateTimeZone {
    private final ZoneRules zoneRules;

    JdkBasedDateTimeZone(String zoneId) {
        super(zoneId);
        this.zoneRules = ZoneId.of(zoneId).getRules();
    }

    public String getNameKey(long instant) {
        return "airlift-name-key-not-provided";
    }

    public int getOffset(long instant) {
        return this.zoneRules.getOffset(Instant.ofEpochMilli(instant)).getTotalSeconds() * 1000;
    }

    public int getStandardOffset(long instant) {
        return this.zoneRules.getStandardOffset(Instant.ofEpochMilli(instant)).getTotalSeconds() * 1000;
    }

    public boolean isFixed() {
        return this.zoneRules.isFixedOffset();
    }

    public long nextTransition(long instant) {
        ZoneOffsetTransition nextTransition = this.zoneRules.nextTransition(Instant.ofEpochMilli(instant));
        if (nextTransition == null) {
            return instant;
        }
        return nextTransition.toEpochSecond() * 1000L;
    }

    public long previousTransition(long instant) {
        ZoneOffsetTransition previousTransition = this.zoneRules.previousTransition(Instant.ofEpochMilli(instant + 1L));
        if (previousTransition == null) {
            return instant;
        }
        return previousTransition.toEpochSecond() * 1000L - 1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JdkBasedDateTimeZone that = (JdkBasedDateTimeZone)((Object)o);
        return Objects.equals(this.getID(), that.getID());
    }

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }
}

