/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.phoenix;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BlockReadFunction;
import io.prestosql.plugin.jdbc.BlockWriteFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DoubleWriteFunction;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.LongWriteFunction;
import io.prestosql.plugin.jdbc.QueryBuilder;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.phoenix.MetadataUtil;
import io.prestosql.plugin.phoenix.PhoenixConfig;
import io.prestosql.plugin.phoenix.PhoenixErrorCode;
import io.prestosql.plugin.phoenix.PhoenixOutputTableHandle;
import io.prestosql.plugin.phoenix.PhoenixSplit;
import io.prestosql.plugin.phoenix.TypeUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.io.IOException;
import java.sql.Array;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RoundRobinResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.DelegatePreparedStatement;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.types.PDataType;

public class PhoenixClient
extends BaseJdbcClient {
    private final Configuration configuration = new Configuration(false);

    @Inject
    public PhoenixClient(PhoenixConfig config) throws SQLException {
        this(config, PhoenixClient.getConnectionProperties(config));
    }

    private PhoenixClient(PhoenixConfig config, Properties connectionProperties) throws SQLException {
        super("\"", (ConnectionFactory)new DriverConnectionFactory(DriverManager.getDriver(config.getConnectionUrl()), config.getConnectionUrl(), Optional.empty(), Optional.empty(), connectionProperties), config.isCaseInsensitiveNameMatching(), config.getCaseInsensitiveNameMatchingCacheTtl());
        connectionProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.configuration.set((String)k, (String)v)));
    }

    private static Properties getConnectionProperties(PhoenixConfig config) throws SQLException {
        Objects.requireNonNull(config, "config is null");
        Configuration resourcesConfig = PhoenixClient.readConfig(config);
        Properties connectionProperties = new Properties();
        for (Map.Entry entry : resourcesConfig) {
            connectionProperties.put(entry.getKey(), entry.getValue());
        }
        PhoenixEmbeddedDriver.ConnectionInfo connectionInfo = PhoenixEmbeddedDriver.ConnectionInfo.create((String)config.getConnectionUrl());
        connectionProperties.putAll((Map<?, ?>)connectionInfo.asProps().asMap());
        return connectionProperties;
    }

    private static Configuration readConfig(PhoenixConfig config) {
        Configuration result = new Configuration(false);
        for (String resourcePath : config.getResourceConfigFiles()) {
            result.addResource(new Path(resourcePath));
        }
        return result;
    }

    public PhoenixConnection getConnection(JdbcIdentity identity) throws SQLException {
        return this.connectionFactory.openConnection(identity).unwrap(PhoenixConnection.class);
    }

    public Connection getHConnection() throws IOException {
        return HBaseFactoryProvider.getHConnectionFactory().createConnection(this.configuration);
    }

    public void execute(ConnectorSession session, String statement) {
        try (java.sql.Connection connection = this.connectionFactory.openConnection(JdbcIdentity.from((ConnectorSession)session));){
            this.execute(connection, statement);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Error while executing statement", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<String> listSchemas(java.sql.Connection connection) {
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            ImmutableSet.Builder schemaNames = ImmutableSet.builder();
            schemaNames.add((Object)"default");
            while (resultSet.next()) {
                String schemaName = resultSet.getString("TABLE_SCHEM");
                if (schemaName == null || schemaName.equalsIgnoreCase("information_schema")) continue;
                schemaNames.add((Object)schemaName);
            }
            ImmutableSet immutableSet = schemaNames.build();
            return immutableSet;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, (Throwable)e);
        }
    }

    public PreparedStatement buildSql(ConnectorSession session, java.sql.Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columnHandles) throws SQLException {
        PhoenixSplit phoenixSplit = (PhoenixSplit)split;
        PreparedStatement query = new QueryBuilder(this.identifierQuote).buildSql((JdbcClient)this, session, connection, table.getCatalogName(), table.getSchemaName(), table.getTableName(), columnHandles, phoenixSplit.getConstraint(), split.getAdditionalPredicate(), this.tryApplyLimit(table.getLimit()));
        QueryPlan queryPlan = this.getQueryPlan((PhoenixPreparedStatement)query);
        final ResultSet resultSet = PhoenixClient.getResultSet(phoenixSplit.getPhoenixInputSplit(), queryPlan);
        return new DelegatePreparedStatement(query){

            public ResultSet executeQuery() throws SQLException {
                return resultSet;
            }
        };
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public String buildInsertSql(JdbcOutputTableHandle handle) {
        PhoenixOutputTableHandle outputHandle = (PhoenixOutputTableHandle)handle;
        String params = String.join((CharSequence)",", Collections.nCopies(handle.getColumnNames().size(), "?"));
        if (outputHandle.hasUUIDRowkey()) {
            String nextId = String.format("NEXT VALUE FOR %s, ", this.quoted(null, handle.getSchemaName(), handle.getTableName() + "_sequence"));
            params = nextId + params;
        }
        return String.format("UPSERT INTO %s VALUES (%s)", this.quoted(null, handle.getSchemaName(), handle.getTableName()), params);
    }

    protected ResultSet getTables(java.sql.Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        return super.getTables(connection, MetadataUtil.toPhoenixSchemaName(schemaName), tableName);
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return (String)MoreObjects.firstNonNull((Object)resultSet.getString("TABLE_SCHEM"), (Object)"default");
    }

    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, java.sql.Connection connection, JdbcTypeHandle typeHandle) {
        switch (typeHandle.getJdbcType()) {
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (typeHandle.getColumnSize() == 0) {
                    return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)VarcharType.createUnboundedVarcharType()));
                }
                return super.toPrestoType(session, connection, typeHandle);
            }
            case 93: 
            case 2013: 
            case 2014: {
                return Optional.empty();
            }
            case 6: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 2003: {
                JdbcTypeHandle elementTypeHandle = this.getArrayElementTypeHandle(session, typeHandle);
                if (elementTypeHandle.getJdbcType() == -3) {
                    return Optional.empty();
                }
                return this.toPrestoType(session, connection, elementTypeHandle).map(elementMapping -> {
                    ArrayType prestoArrayType = new ArrayType(elementMapping.getType());
                    String jdbcTypeName = (String)elementTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Type name is missing for jdbc type: " + JDBCType.valueOf(elementTypeHandle.getJdbcType())));
                    return PhoenixClient.arrayColumnMapping(session, prestoArrayType, jdbcTypeName);
                });
            }
        }
        return super.toPrestoType(session, connection, typeHandle);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return WriteMapping.doubleMapping((String)"double", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (RealType.REAL.equals((Object)type)) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (TimeType.TIME.equals((Object)type)) {
            return WriteMapping.longMapping((String)"time", (LongWriteFunction)StandardColumnMappings.timeWriteFunction());
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType().toUpperCase();
            String elementWriteName = TypeUtils.getArrayElementPhoenixTypeName(session, this, elementType);
            return WriteMapping.blockMapping((String)(elementDataType + " ARRAY"), (BlockWriteFunction)PhoenixClient.arrayWriteFunction(session, elementType, elementWriteName));
        }
        return super.toWriteMapping(session, type);
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, String elementJdbcTypeName) {
        return ColumnMapping.blockMapping((Type)arrayType, (BlockReadFunction)PhoenixClient.arrayReadFunction(session, arrayType.getElementType()), (BlockWriteFunction)PhoenixClient.arrayWriteFunction(session, arrayType.getElementType(), elementJdbcTypeName));
    }

    private static BlockReadFunction arrayReadFunction(ConnectorSession session, Type elementType) {
        return (resultSet, columnIndex) -> {
            Object[] objectArray = TypeUtils.toBoxedArray(resultSet.getArray(columnIndex).getArray());
            return TypeUtils.jdbcObjectArrayToBlock(session, elementType, objectArray);
        };
    }

    private static BlockWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String elementJdbcTypeName) {
        return (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(elementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        };
    }

    private JdbcTypeHandle getArrayElementTypeHandle(ConnectorSession session, JdbcTypeHandle arrayTypeHandle) {
        String arrayTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Type name is missing for jdbc type: " + JDBCType.valueOf(arrayTypeHandle.getJdbcType())));
        Preconditions.checkArgument((boolean)arrayTypeName.endsWith(" ARRAY"), (Object)"array type must end with ' ARRAY'");
        arrayTypeName = arrayTypeName.substring(0, arrayTypeName.length() - " ARRAY".length());
        return new JdbcTypeHandle(PDataType.fromSqlTypeName((String)arrayTypeName).getSqlType(), Optional.of(arrayTypeName), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions());
    }

    public QueryPlan getQueryPlan(PhoenixPreparedStatement inputQuery) {
        try {
            QueryPlan queryPlan = inputQuery.optimizeQuery();
            queryPlan.iterator((ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
            return queryPlan;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Failed to get the Phoenix query plan", (Throwable)e);
        }
    }

    private static ResultSet getResultSet(PhoenixInputSplit split, QueryPlan queryPlan) {
        List scans = split.getScans();
        try {
            PeekingResultIterator iterator;
            ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(scans.size());
            StatementContext context = queryPlan.getContext();
            PName physicalTableName = queryPlan.getTableRef().getTable().getPhysicalName();
            PhoenixConnection phoenixConnection = context.getConnection();
            ConnectionQueryServices services = phoenixConnection.getQueryServices();
            services.clearTableRegionCache(physicalTableName.getBytes());
            for (Scan scan : scans) {
                scan = new Scan(scan);
                scan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance((ReadMetricQueue)context.getReadMetricsQueue(), (String)physicalTableName.getString(), (Scan)scan, (LogLevel)phoenixConnection.getLogLevel());
                TableResultIterator tableResultIterator = new TableResultIterator(phoenixConnection.getMutationState(), scan, scanMetricsHolder, services.getRenewLeaseThresholdMilliSeconds(), queryPlan, (ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
                iterators.add(LookAheadResultIterator.wrap((ResultIterator)tableResultIterator));
            }
            Object object = iterator = queryPlan.useRoundRobinIterator() ? RoundRobinResultIterator.newIterator(iterators, (QueryPlan)queryPlan) : ConcatResultIterator.newIterator(iterators);
            if (context.getSequenceManager().getSequenceCount() > 0) {
                iterator = new SequenceResultIterator((ResultIterator)iterator, context.getSequenceManager());
            }
            return new PhoenixResultSet((ResultIterator)iterator, queryPlan.getProjector().cloneIfNecessary(), context);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Error while setting up Phoenix ResultSet", (Throwable)e);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_INTERNAL_ERROR, "Error while copying scan", (Throwable)e);
        }
    }
}

